<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Article StructType
 * @subpackage Structs
 */
class Article extends BaseContract_FullIDSet
{
    /**
     * The LastMove
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastMove;
    /**
     * The BasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BasePrice;
    /**
     * The UnrealisticPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnrealisticPrice;
    /**
     * The IsNOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNOS;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The LongDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LongDescription;
    /**
     * The InternalNumberI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalNumberI;
    /**
     * The InternalNumberII
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalNumberII;
    /**
     * The InternalShortDescI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalShortDescI;
    /**
     * The InternalShortDescII
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalShortDescII;
    /**
     * The MemoI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MemoI;
    /**
     * The MemoII
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MemoII;
    /**
     * The SizeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SizeRange;
    /**
     * The Season
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Season;
    /**
     * The PictureURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PictureURI;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The ProductGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductGroup
     */
    public $ProductGroup;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Manufacturer
     */
    public $Manufacturer;
    /**
     * The Appearances
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBranch
     */
    public $Appearances;
    /**
     * The ColorEanPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfColorEanPrices
     */
    public $ColorEanPrices;
    /**
     * The Characteristics
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCharacteristic
     */
    public $Characteristics;
    /**
     * Constructor method for Article
     * @uses Article::setLastMove()
     * @uses Article::setBasePrice()
     * @uses Article::setUnrealisticPrice()
     * @uses Article::setIsNOS()
     * @uses Article::setDescription()
     * @uses Article::setLongDescription()
     * @uses Article::setInternalNumberI()
     * @uses Article::setInternalNumberII()
     * @uses Article::setInternalShortDescI()
     * @uses Article::setInternalShortDescII()
     * @uses Article::setMemoI()
     * @uses Article::setMemoII()
     * @uses Article::setSizeRange()
     * @uses Article::setSeason()
     * @uses Article::setPictureURI()
     * @uses Article::setBrand()
     * @uses Article::setProductGroup()
     * @uses Article::setManufacturer()
     * @uses Article::setAppearances()
     * @uses Article::setColorEanPrices()
     * @uses Article::setCharacteristics()
     * @param string $lastMove
     * @param float $basePrice
     * @param float $unrealisticPrice
     * @param bool $isNOS
     * @param string $description
     * @param string $longDescription
     * @param string $internalNumberI
     * @param string $internalNumberII
     * @param string $internalShortDescI
     * @param string $internalShortDescII
     * @param string $memoI
     * @param string $memoII
     * @param string $sizeRange
     * @param string $season
     * @param string $pictureURI
     * @param string $brand
     * @param \StructType\ProductGroup $productGroup
     * @param \StructType\Manufacturer $manufacturer
     * @param \ArrayType\ArrayOfBranch $appearances
     * @param \ArrayType\ArrayOfColorEanPrices $colorEanPrices
     * @param \ArrayType\ArrayOfCharacteristic $characteristics
     */
    public function __construct($lastMove = null, $basePrice = null, $unrealisticPrice = null, $isNOS = null, $description = null, $longDescription = null, $internalNumberI = null, $internalNumberII = null, $internalShortDescI = null, $internalShortDescII = null, $memoI = null, $memoII = null, $sizeRange = null, $season = null, $pictureURI = null, $brand = null, \StructType\ProductGroup $productGroup = null, \StructType\Manufacturer $manufacturer = null, \ArrayType\ArrayOfBranch $appearances = null, \ArrayType\ArrayOfColorEanPrices $colorEanPrices = null, \ArrayType\ArrayOfCharacteristic $characteristics = null)
    {
        $this
            ->setLastMove($lastMove)
            ->setBasePrice($basePrice)
            ->setUnrealisticPrice($unrealisticPrice)
            ->setIsNOS($isNOS)
            ->setDescription($description)
            ->setLongDescription($longDescription)
            ->setInternalNumberI($internalNumberI)
            ->setInternalNumberII($internalNumberII)
            ->setInternalShortDescI($internalShortDescI)
            ->setInternalShortDescII($internalShortDescII)
            ->setMemoI($memoI)
            ->setMemoII($memoII)
            ->setSizeRange($sizeRange)
            ->setSeason($season)
            ->setPictureURI($pictureURI)
            ->setBrand($brand)
            ->setProductGroup($productGroup)
            ->setManufacturer($manufacturer)
            ->setAppearances($appearances)
            ->setColorEanPrices($colorEanPrices)
            ->setCharacteristics($characteristics);
    }
    /**
     * Get LastMove value
     * @return string
     */
    public function getLastMove()
    {
        return $this->LastMove;
    }
    /**
     * Set LastMove value
     * @param string $lastMove
     * @return \StructType\Article
     */
    public function setLastMove($lastMove = null)
    {
        // validation for constraint: string
        if (!is_null($lastMove) && !is_string($lastMove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastMove, true), gettype($lastMove)), __LINE__);
        }
        $this->LastMove = $lastMove;
        return $this;
    }
    /**
     * Get BasePrice value
     * @return float
     */
    public function getBasePrice()
    {
        return $this->BasePrice;
    }
    /**
     * Set BasePrice value
     * @param float $basePrice
     * @return \StructType\Article
     */
    public function setBasePrice($basePrice = null)
    {
        // validation for constraint: float
        if (!is_null($basePrice) && !(is_float($basePrice) || is_numeric($basePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basePrice, true), gettype($basePrice)), __LINE__);
        }
        $this->BasePrice = $basePrice;
        return $this;
    }
    /**
     * Get UnrealisticPrice value
     * @return float
     */
    public function getUnrealisticPrice()
    {
        return $this->UnrealisticPrice;
    }
    /**
     * Set UnrealisticPrice value
     * @param float $unrealisticPrice
     * @return \StructType\Article
     */
    public function setUnrealisticPrice($unrealisticPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unrealisticPrice) && !(is_float($unrealisticPrice) || is_numeric($unrealisticPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unrealisticPrice, true), gettype($unrealisticPrice)), __LINE__);
        }
        $this->UnrealisticPrice = $unrealisticPrice;
        return $this;
    }
    /**
     * Get IsNOS value
     * @return bool
     */
    public function getIsNOS()
    {
        return $this->IsNOS;
    }
    /**
     * Set IsNOS value
     * @param bool $isNOS
     * @return \StructType\Article
     */
    public function setIsNOS($isNOS = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNOS) && !is_bool($isNOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNOS, true), gettype($isNOS)), __LINE__);
        }
        $this->IsNOS = $isNOS;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Article
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param string $longDescription
     * @return \StructType\Article
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longDescription, true), gettype($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get InternalNumberI value
     * @return string|null
     */
    public function getInternalNumberI()
    {
        return $this->InternalNumberI;
    }
    /**
     * Set InternalNumberI value
     * @param string $internalNumberI
     * @return \StructType\Article
     */
    public function setInternalNumberI($internalNumberI = null)
    {
        // validation for constraint: string
        if (!is_null($internalNumberI) && !is_string($internalNumberI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNumberI, true), gettype($internalNumberI)), __LINE__);
        }
        $this->InternalNumberI = $internalNumberI;
        return $this;
    }
    /**
     * Get InternalNumberII value
     * @return string|null
     */
    public function getInternalNumberII()
    {
        return $this->InternalNumberII;
    }
    /**
     * Set InternalNumberII value
     * @param string $internalNumberII
     * @return \StructType\Article
     */
    public function setInternalNumberII($internalNumberII = null)
    {
        // validation for constraint: string
        if (!is_null($internalNumberII) && !is_string($internalNumberII)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNumberII, true), gettype($internalNumberII)), __LINE__);
        }
        $this->InternalNumberII = $internalNumberII;
        return $this;
    }
    /**
     * Get InternalShortDescI value
     * @return string|null
     */
    public function getInternalShortDescI()
    {
        return $this->InternalShortDescI;
    }
    /**
     * Set InternalShortDescI value
     * @param string $internalShortDescI
     * @return \StructType\Article
     */
    public function setInternalShortDescI($internalShortDescI = null)
    {
        // validation for constraint: string
        if (!is_null($internalShortDescI) && !is_string($internalShortDescI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalShortDescI, true), gettype($internalShortDescI)), __LINE__);
        }
        $this->InternalShortDescI = $internalShortDescI;
        return $this;
    }
    /**
     * Get InternalShortDescII value
     * @return string|null
     */
    public function getInternalShortDescII()
    {
        return $this->InternalShortDescII;
    }
    /**
     * Set InternalShortDescII value
     * @param string $internalShortDescII
     * @return \StructType\Article
     */
    public function setInternalShortDescII($internalShortDescII = null)
    {
        // validation for constraint: string
        if (!is_null($internalShortDescII) && !is_string($internalShortDescII)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalShortDescII, true), gettype($internalShortDescII)), __LINE__);
        }
        $this->InternalShortDescII = $internalShortDescII;
        return $this;
    }
    /**
     * Get MemoI value
     * @return string|null
     */
    public function getMemoI()
    {
        return $this->MemoI;
    }
    /**
     * Set MemoI value
     * @param string $memoI
     * @return \StructType\Article
     */
    public function setMemoI($memoI = null)
    {
        // validation for constraint: string
        if (!is_null($memoI) && !is_string($memoI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memoI, true), gettype($memoI)), __LINE__);
        }
        $this->MemoI = $memoI;
        return $this;
    }
    /**
     * Get MemoII value
     * @return string|null
     */
    public function getMemoII()
    {
        return $this->MemoII;
    }
    /**
     * Set MemoII value
     * @param string $memoII
     * @return \StructType\Article
     */
    public function setMemoII($memoII = null)
    {
        // validation for constraint: string
        if (!is_null($memoII) && !is_string($memoII)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memoII, true), gettype($memoII)), __LINE__);
        }
        $this->MemoII = $memoII;
        return $this;
    }
    /**
     * Get SizeRange value
     * @return string|null
     */
    public function getSizeRange()
    {
        return $this->SizeRange;
    }
    /**
     * Set SizeRange value
     * @param string $sizeRange
     * @return \StructType\Article
     */
    public function setSizeRange($sizeRange = null)
    {
        // validation for constraint: string
        if (!is_null($sizeRange) && !is_string($sizeRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeRange, true), gettype($sizeRange)), __LINE__);
        }
        $this->SizeRange = $sizeRange;
        return $this;
    }
    /**
     * Get Season value
     * @return string|null
     */
    public function getSeason()
    {
        return $this->Season;
    }
    /**
     * Set Season value
     * @param string $season
     * @return \StructType\Article
     */
    public function setSeason($season = null)
    {
        // validation for constraint: string
        if (!is_null($season) && !is_string($season)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($season, true), gettype($season)), __LINE__);
        }
        $this->Season = $season;
        return $this;
    }
    /**
     * Get PictureURI value
     * @return string|null
     */
    public function getPictureURI()
    {
        return $this->PictureURI;
    }
    /**
     * Set PictureURI value
     * @param string $pictureURI
     * @return \StructType\Article
     */
    public function setPictureURI($pictureURI = null)
    {
        // validation for constraint: string
        if (!is_null($pictureURI) && !is_string($pictureURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureURI, true), gettype($pictureURI)), __LINE__);
        }
        $this->PictureURI = $pictureURI;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\Article
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get ProductGroup value
     * @return \StructType\ProductGroup|null
     */
    public function getProductGroup()
    {
        return $this->ProductGroup;
    }
    /**
     * Set ProductGroup value
     * @param \StructType\ProductGroup $productGroup
     * @return \StructType\Article
     */
    public function setProductGroup(\StructType\ProductGroup $productGroup = null)
    {
        $this->ProductGroup = $productGroup;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return \StructType\Manufacturer|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param \StructType\Manufacturer $manufacturer
     * @return \StructType\Article
     */
    public function setManufacturer(\StructType\Manufacturer $manufacturer = null)
    {
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Appearances value
     * @return \ArrayType\ArrayOfBranch|null
     */
    public function getAppearances()
    {
        return $this->Appearances;
    }
    /**
     * Set Appearances value
     * @param \ArrayType\ArrayOfBranch $appearances
     * @return \StructType\Article
     */
    public function setAppearances(\ArrayType\ArrayOfBranch $appearances = null)
    {
        $this->Appearances = $appearances;
        return $this;
    }
    /**
     * Get ColorEanPrices value
     * @return \ArrayType\ArrayOfColorEanPrices|null
     */
    public function getColorEanPrices()
    {
        return $this->ColorEanPrices;
    }
    /**
     * Set ColorEanPrices value
     * @param \ArrayType\ArrayOfColorEanPrices $colorEanPrices
     * @return \StructType\Article
     */
    public function setColorEanPrices(\ArrayType\ArrayOfColorEanPrices $colorEanPrices = null)
    {
        $this->ColorEanPrices = $colorEanPrices;
        return $this;
    }
    /**
     * Get Characteristics value
     * @return \ArrayType\ArrayOfCharacteristic|null
     */
    public function getCharacteristics()
    {
        return $this->Characteristics;
    }
    /**
     * Set Characteristics value
     * @param \ArrayType\ArrayOfCharacteristic $characteristics
     * @return \StructType\Article
     */
    public function setCharacteristics(\ArrayType\ArrayOfCharacteristic $characteristics = null)
    {
        $this->Characteristics = $characteristics;
        return $this;
    }
}
