<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateIbt
     * Meta information extracted from the WSDL
     * - documentation: Creates the IBT.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateIbt $parameters
     * @return \StructType\CreateIbtResponse|bool
     */
    public function CreateIbt(\StructType\CreateIbt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateIbt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateIbtResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
