<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ProcessingStatus EnumType
 * @subpackage Enumerations
 */
class ProcessingStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'FINISHED'
     * @return string 'FINISHED'
     */
    const VALUE_FINISHED = 'FINISHED';
    /**
     * Constant for value 'RUNNING'
     * @return string 'RUNNING'
     */
    const VALUE_RUNNING = 'RUNNING';
    /**
     * Constant for value 'PENDING'
     * @return string 'PENDING'
     */
    const VALUE_PENDING = 'PENDING';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Constant for value 'ABORTED'
     * @return string 'ABORTED'
     */
    const VALUE_ABORTED = 'ABORTED';
    /**
     * Constant for value 'STARTED'
     * @return string 'STARTED'
     */
    const VALUE_STARTED = 'STARTED';
    /**
     * Return allowed values
     * @uses self::VALUE_FINISHED
     * @uses self::VALUE_RUNNING
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_ABORTED
     * @uses self::VALUE_STARTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FINISHED,
            self::VALUE_RUNNING,
            self::VALUE_PENDING,
            self::VALUE_REJECTED,
            self::VALUE_ABORTED,
            self::VALUE_STARTED,
        );
    }
}
