<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CreationStatus EnumType
 * @subpackage Enumerations
 */
class CreationStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'PartlyError'
     * @return string 'PartlyError'
     */
    const VALUE_PARTLY_ERROR = 'PartlyError';
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_NONE
     * @uses self::VALUE_PARTLY_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_ERROR,
            self::VALUE_NONE,
            self::VALUE_PARTLY_ERROR,
        );
    }
}
