<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStockInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfStockInfo extends AbstractStructArrayBase
{
    /**
     * The StockInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockInfo[]
     */
    public $StockInfo;
    /**
     * Constructor method for ArrayOfStockInfo
     * @uses ArrayOfStockInfo::setStockInfo()
     * @param \StructType\StockInfo[] $stockInfo
     */
    public function __construct(array $stockInfo = array())
    {
        $this
            ->setStockInfo($stockInfo);
    }
    /**
     * Get StockInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockInfo[]|null
     */
    public function getStockInfo()
    {
        return isset($this->StockInfo) ? $this->StockInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStockInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStockInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockInfoForArrayConstraintsFromSetStockInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStockInfoStockInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfStockInfoStockInfoItem instanceof \StructType\StockInfo) {
                $invalidValues[] = is_object($arrayOfStockInfoStockInfoItem) ? get_class($arrayOfStockInfoStockInfoItem) : sprintf('%s(%s)', gettype($arrayOfStockInfoStockInfoItem), var_export($arrayOfStockInfoStockInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StockInfo property can only contain items of type \StructType\StockInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StockInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StockInfo[] $stockInfo
     * @return \ArrayType\ArrayOfStockInfo
     */
    public function setStockInfo(array $stockInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($stockInfoArrayErrorMessage = self::validateStockInfoForArrayConstraintsFromSetStockInfo($stockInfo))) {
            throw new \InvalidArgumentException($stockInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($stockInfo) || (is_array($stockInfo) && empty($stockInfo))) {
            unset($this->StockInfo);
        } else {
            $this->StockInfo = $stockInfo;
        }
        return $this;
    }
    /**
     * Add item to StockInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\StockInfo $item
     * @return \ArrayType\ArrayOfStockInfo
     */
    public function addToStockInfo(\StructType\StockInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockInfo) {
            throw new \InvalidArgumentException(sprintf('The StockInfo property can only contain items of type \StructType\StockInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StockInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\StockInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\StockInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\StockInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\StockInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\StockInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StockInfo
     */
    public function getAttributeName()
    {
        return 'StockInfo';
    }
}
