<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSizeRange ArrayType
 * @subpackage Arrays
 */
class ArrayOfSizeRange extends AbstractStructArrayBase
{
    /**
     * The SizeRange
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SizeRange[]
     */
    public $SizeRange;
    /**
     * Constructor method for ArrayOfSizeRange
     * @uses ArrayOfSizeRange::setSizeRange()
     * @param \StructType\SizeRange[] $sizeRange
     */
    public function __construct(array $sizeRange = array())
    {
        $this
            ->setSizeRange($sizeRange);
    }
    /**
     * Get SizeRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SizeRange[]|null
     */
    public function getSizeRange()
    {
        return isset($this->SizeRange) ? $this->SizeRange : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSizeRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSizeRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSizeRangeForArrayConstraintsFromSetSizeRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSizeRangeSizeRangeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSizeRangeSizeRangeItem instanceof \StructType\SizeRange) {
                $invalidValues[] = is_object($arrayOfSizeRangeSizeRangeItem) ? get_class($arrayOfSizeRangeSizeRangeItem) : sprintf('%s(%s)', gettype($arrayOfSizeRangeSizeRangeItem), var_export($arrayOfSizeRangeSizeRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SizeRange property can only contain items of type \StructType\SizeRange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SizeRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SizeRange[] $sizeRange
     * @return \ArrayType\ArrayOfSizeRange
     */
    public function setSizeRange(array $sizeRange = array())
    {
        // validation for constraint: array
        if ('' !== ($sizeRangeArrayErrorMessage = self::validateSizeRangeForArrayConstraintsFromSetSizeRange($sizeRange))) {
            throw new \InvalidArgumentException($sizeRangeArrayErrorMessage, __LINE__);
        }
        if (is_null($sizeRange) || (is_array($sizeRange) && empty($sizeRange))) {
            unset($this->SizeRange);
        } else {
            $this->SizeRange = $sizeRange;
        }
        return $this;
    }
    /**
     * Add item to SizeRange value
     * @throws \InvalidArgumentException
     * @param \StructType\SizeRange $item
     * @return \ArrayType\ArrayOfSizeRange
     */
    public function addToSizeRange(\StructType\SizeRange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SizeRange) {
            throw new \InvalidArgumentException(sprintf('The SizeRange property can only contain items of type \StructType\SizeRange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SizeRange[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SizeRange|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SizeRange|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SizeRange|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SizeRange|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SizeRange|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SizeRange
     */
    public function getAttributeName()
    {
        return 'SizeRange';
    }
}
