<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfScanCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfScanCode extends AbstractStructArrayBase
{
    /**
     * The ScanCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ScanCode[]
     */
    public $ScanCode;
    /**
     * Constructor method for ArrayOfScanCode
     * @uses ArrayOfScanCode::setScanCode()
     * @param \StructType\ScanCode[] $scanCode
     */
    public function __construct(array $scanCode = array())
    {
        $this
            ->setScanCode($scanCode);
    }
    /**
     * Get ScanCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ScanCode[]|null
     */
    public function getScanCode()
    {
        return isset($this->ScanCode) ? $this->ScanCode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setScanCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setScanCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateScanCodeForArrayConstraintsFromSetScanCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfScanCodeScanCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfScanCodeScanCodeItem instanceof \StructType\ScanCode) {
                $invalidValues[] = is_object($arrayOfScanCodeScanCodeItem) ? get_class($arrayOfScanCodeScanCodeItem) : sprintf('%s(%s)', gettype($arrayOfScanCodeScanCodeItem), var_export($arrayOfScanCodeScanCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ScanCode property can only contain items of type \StructType\ScanCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ScanCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ScanCode[] $scanCode
     * @return \ArrayType\ArrayOfScanCode
     */
    public function setScanCode(array $scanCode = array())
    {
        // validation for constraint: array
        if ('' !== ($scanCodeArrayErrorMessage = self::validateScanCodeForArrayConstraintsFromSetScanCode($scanCode))) {
            throw new \InvalidArgumentException($scanCodeArrayErrorMessage, __LINE__);
        }
        if (is_null($scanCode) || (is_array($scanCode) && empty($scanCode))) {
            unset($this->ScanCode);
        } else {
            $this->ScanCode = $scanCode;
        }
        return $this;
    }
    /**
     * Add item to ScanCode value
     * @throws \InvalidArgumentException
     * @param \StructType\ScanCode $item
     * @return \ArrayType\ArrayOfScanCode
     */
    public function addToScanCode(\StructType\ScanCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ScanCode) {
            throw new \InvalidArgumentException(sprintf('The ScanCode property can only contain items of type \StructType\ScanCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ScanCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ScanCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ScanCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ScanCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ScanCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ScanCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ScanCode
     */
    public function getAttributeName()
    {
        return 'ScanCode';
    }
}
