<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoicePosition ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoicePosition extends AbstractStructArrayBase
{
    /**
     * The InvoicePosition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoicePosition[]
     */
    public $InvoicePosition;
    /**
     * Constructor method for ArrayOfInvoicePosition
     * @uses ArrayOfInvoicePosition::setInvoicePosition()
     * @param \StructType\InvoicePosition[] $invoicePosition
     */
    public function __construct(array $invoicePosition = array())
    {
        $this
            ->setInvoicePosition($invoicePosition);
    }
    /**
     * Get InvoicePosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoicePosition[]|null
     */
    public function getInvoicePosition()
    {
        return isset($this->InvoicePosition) ? $this->InvoicePosition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicePosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicePosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicePositionForArrayConstraintsFromSetInvoicePosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoicePositionInvoicePositionItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoicePositionInvoicePositionItem instanceof \StructType\InvoicePosition) {
                $invalidValues[] = is_object($arrayOfInvoicePositionInvoicePositionItem) ? get_class($arrayOfInvoicePositionInvoicePositionItem) : sprintf('%s(%s)', gettype($arrayOfInvoicePositionInvoicePositionItem), var_export($arrayOfInvoicePositionInvoicePositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicePosition property can only contain items of type \StructType\InvoicePosition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicePosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicePosition[] $invoicePosition
     * @return \ArrayType\ArrayOfInvoicePosition
     */
    public function setInvoicePosition(array $invoicePosition = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicePositionArrayErrorMessage = self::validateInvoicePositionForArrayConstraintsFromSetInvoicePosition($invoicePosition))) {
            throw new \InvalidArgumentException($invoicePositionArrayErrorMessage, __LINE__);
        }
        if (is_null($invoicePosition) || (is_array($invoicePosition) && empty($invoicePosition))) {
            unset($this->InvoicePosition);
        } else {
            $this->InvoicePosition = $invoicePosition;
        }
        return $this;
    }
    /**
     * Add item to InvoicePosition value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicePosition $item
     * @return \ArrayType\ArrayOfInvoicePosition
     */
    public function addToInvoicePosition(\StructType\InvoicePosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoicePosition) {
            throw new \InvalidArgumentException(sprintf('The InvoicePosition property can only contain items of type \StructType\InvoicePosition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicePosition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoicePosition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoicePosition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoicePosition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoicePosition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoicePosition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoicePosition
     */
    public function getAttributeName()
    {
        return 'InvoicePosition';
    }
}
