<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeletedObjectReference ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeletedObjectReference extends AbstractStructArrayBase
{
    /**
     * The DeletedObjectReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeletedObjectReference[]
     */
    public $DeletedObjectReference;
    /**
     * Constructor method for ArrayOfDeletedObjectReference
     * @uses ArrayOfDeletedObjectReference::setDeletedObjectReference()
     * @param \StructType\DeletedObjectReference[] $deletedObjectReference
     */
    public function __construct(array $deletedObjectReference = array())
    {
        $this
            ->setDeletedObjectReference($deletedObjectReference);
    }
    /**
     * Get DeletedObjectReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeletedObjectReference[]|null
     */
    public function getDeletedObjectReference()
    {
        return isset($this->DeletedObjectReference) ? $this->DeletedObjectReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeletedObjectReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeletedObjectReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeletedObjectReferenceForArrayConstraintsFromSetDeletedObjectReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeletedObjectReferenceDeletedObjectReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeletedObjectReferenceDeletedObjectReferenceItem instanceof \StructType\DeletedObjectReference) {
                $invalidValues[] = is_object($arrayOfDeletedObjectReferenceDeletedObjectReferenceItem) ? get_class($arrayOfDeletedObjectReferenceDeletedObjectReferenceItem) : sprintf('%s(%s)', gettype($arrayOfDeletedObjectReferenceDeletedObjectReferenceItem), var_export($arrayOfDeletedObjectReferenceDeletedObjectReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeletedObjectReference property can only contain items of type \StructType\DeletedObjectReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeletedObjectReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeletedObjectReference[] $deletedObjectReference
     * @return \ArrayType\ArrayOfDeletedObjectReference
     */
    public function setDeletedObjectReference(array $deletedObjectReference = array())
    {
        // validation for constraint: array
        if ('' !== ($deletedObjectReferenceArrayErrorMessage = self::validateDeletedObjectReferenceForArrayConstraintsFromSetDeletedObjectReference($deletedObjectReference))) {
            throw new \InvalidArgumentException($deletedObjectReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($deletedObjectReference) || (is_array($deletedObjectReference) && empty($deletedObjectReference))) {
            unset($this->DeletedObjectReference);
        } else {
            $this->DeletedObjectReference = $deletedObjectReference;
        }
        return $this;
    }
    /**
     * Add item to DeletedObjectReference value
     * @throws \InvalidArgumentException
     * @param \StructType\DeletedObjectReference $item
     * @return \ArrayType\ArrayOfDeletedObjectReference
     */
    public function addToDeletedObjectReference(\StructType\DeletedObjectReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeletedObjectReference) {
            throw new \InvalidArgumentException(sprintf('The DeletedObjectReference property can only contain items of type \StructType\DeletedObjectReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeletedObjectReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeletedObjectReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeletedObjectReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeletedObjectReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeletedObjectReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeletedObjectReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeletedObjectReference
     */
    public function getAttributeName()
    {
        return 'DeletedObjectReference';
    }
}
