<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerCard ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerCard extends AbstractStructArrayBase
{
    /**
     * The CustomerCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerCard[]
     */
    public $CustomerCard;
    /**
     * Constructor method for ArrayOfCustomerCard
     * @uses ArrayOfCustomerCard::setCustomerCard()
     * @param \StructType\CustomerCard[] $customerCard
     */
    public function __construct(array $customerCard = array())
    {
        $this
            ->setCustomerCard($customerCard);
    }
    /**
     * Get CustomerCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerCard[]|null
     */
    public function getCustomerCard()
    {
        return isset($this->CustomerCard) ? $this->CustomerCard : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerCardForArrayConstraintsFromSetCustomerCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerCardCustomerCardItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerCardCustomerCardItem instanceof \StructType\CustomerCard) {
                $invalidValues[] = is_object($arrayOfCustomerCardCustomerCardItem) ? get_class($arrayOfCustomerCardCustomerCardItem) : sprintf('%s(%s)', gettype($arrayOfCustomerCardCustomerCardItem), var_export($arrayOfCustomerCardCustomerCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerCard property can only contain items of type \StructType\CustomerCard, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCard[] $customerCard
     * @return \ArrayType\ArrayOfCustomerCard
     */
    public function setCustomerCard(array $customerCard = array())
    {
        // validation for constraint: array
        if ('' !== ($customerCardArrayErrorMessage = self::validateCustomerCardForArrayConstraintsFromSetCustomerCard($customerCard))) {
            throw new \InvalidArgumentException($customerCardArrayErrorMessage, __LINE__);
        }
        if (is_null($customerCard) || (is_array($customerCard) && empty($customerCard))) {
            unset($this->CustomerCard);
        } else {
            $this->CustomerCard = $customerCard;
        }
        return $this;
    }
    /**
     * Add item to CustomerCard value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCard $item
     * @return \ArrayType\ArrayOfCustomerCard
     */
    public function addToCustomerCard(\StructType\CustomerCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerCard) {
            throw new \InvalidArgumentException(sprintf('The CustomerCard property can only contain items of type \StructType\CustomerCard, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerCard[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerCard|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerCard|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerCard|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerCard|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerCard|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerCard
     */
    public function getAttributeName()
    {
        return 'CustomerCard';
    }
}
