<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBranch ArrayType
 * @subpackage Arrays
 */
class ArrayOfBranch extends AbstractStructArrayBase
{
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Branch[]
     */
    public $Branch;
    /**
     * Constructor method for ArrayOfBranch
     * @uses ArrayOfBranch::setBranch()
     * @param \StructType\Branch[] $branch
     */
    public function __construct(array $branch = array())
    {
        $this
            ->setBranch($branch);
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Branch[]|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBranch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBranch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBranchForArrayConstraintsFromSetBranch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBranchBranchItem) {
            // validation for constraint: itemType
            if (!$arrayOfBranchBranchItem instanceof \StructType\Branch) {
                $invalidValues[] = is_object($arrayOfBranchBranchItem) ? get_class($arrayOfBranchBranchItem) : sprintf('%s(%s)', gettype($arrayOfBranchBranchItem), var_export($arrayOfBranchBranchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Branch property can only contain items of type \StructType\Branch, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Branch[] $branch
     * @return \ArrayType\ArrayOfBranch
     */
    public function setBranch(array $branch = array())
    {
        // validation for constraint: array
        if ('' !== ($branchArrayErrorMessage = self::validateBranchForArrayConstraintsFromSetBranch($branch))) {
            throw new \InvalidArgumentException($branchArrayErrorMessage, __LINE__);
        }
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Add item to Branch value
     * @throws \InvalidArgumentException
     * @param \StructType\Branch $item
     * @return \ArrayType\ArrayOfBranch
     */
    public function addToBranch(\StructType\Branch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Branch) {
            throw new \InvalidArgumentException(sprintf('The Branch property can only contain items of type \StructType\Branch, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Branch[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Branch|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Branch|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Branch|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Branch|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Branch|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Branch
     */
    public function getAttributeName()
    {
        return 'Branch';
    }
}
