<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * @subpackage Structs
 */
class Voucher extends BaseContract_FullIDSet
{
    /**
     * The VoucherType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VoucherType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The Remainder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Remainder;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidFrom;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpirationDate;
    /**
     * The RedeemDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RedeemDate;
    /**
     * The SalesDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesDate;
    /**
     * The LastChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastChange;
    /**
     * The IsRedeemed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRedeemed;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrinted;
    /**
     * The ScanCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanCode;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setVoucherType()
     * @uses Voucher::setAmount()
     * @uses Voucher::setRemainder()
     * @uses Voucher::setValidFrom()
     * @uses Voucher::setExpirationDate()
     * @uses Voucher::setRedeemDate()
     * @uses Voucher::setSalesDate()
     * @uses Voucher::setLastChange()
     * @uses Voucher::setIsRedeemed()
     * @uses Voucher::setIsDeleted()
     * @uses Voucher::setIsPrinted()
     * @uses Voucher::setScanCode()
     * @uses Voucher::setCurrencyISO()
     * @uses Voucher::setBranchId()
     * @uses Voucher::setShopId()
     * @uses Voucher::setCustomerId()
     * @uses Voucher::setShopCustomerId()
     * @uses Voucher::setInfo()
     * @param string $voucherType
     * @param float $amount
     * @param float $remainder
     * @param string $validFrom
     * @param string $expirationDate
     * @param string $redeemDate
     * @param string $salesDate
     * @param string $lastChange
     * @param bool $isRedeemed
     * @param bool $isDeleted
     * @param bool $isPrinted
     * @param string $scanCode
     * @param string $currencyISO
     * @param string $branchId
     * @param string $shopId
     * @param string $customerId
     * @param string $shopCustomerId
     * @param string $info
     */
    public function __construct($voucherType = null, $amount = null, $remainder = null, $validFrom = null, $expirationDate = null, $redeemDate = null, $salesDate = null, $lastChange = null, $isRedeemed = null, $isDeleted = null, $isPrinted = null, $scanCode = null, $currencyISO = null, $branchId = null, $shopId = null, $customerId = null, $shopCustomerId = null, $info = null)
    {
        $this
            ->setVoucherType($voucherType)
            ->setAmount($amount)
            ->setRemainder($remainder)
            ->setValidFrom($validFrom)
            ->setExpirationDate($expirationDate)
            ->setRedeemDate($redeemDate)
            ->setSalesDate($salesDate)
            ->setLastChange($lastChange)
            ->setIsRedeemed($isRedeemed)
            ->setIsDeleted($isDeleted)
            ->setIsPrinted($isPrinted)
            ->setScanCode($scanCode)
            ->setCurrencyISO($currencyISO)
            ->setBranchId($branchId)
            ->setShopId($shopId)
            ->setCustomerId($customerId)
            ->setShopCustomerId($shopCustomerId)
            ->setInfo($info);
    }
    /**
     * Get VoucherType value
     * @return string
     */
    public function getVoucherType()
    {
        return $this->VoucherType;
    }
    /**
     * Set VoucherType value
     * @uses \EnumType\VoucherType::valueIsValid()
     * @uses \EnumType\VoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $voucherType
     * @return \StructType\Voucher
     */
    public function setVoucherType($voucherType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherType::valueIsValid($voucherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VoucherType', is_array($voucherType) ? implode(', ', $voucherType) : var_export($voucherType, true), implode(', ', \EnumType\VoucherType::getValidValues())), __LINE__);
        }
        $this->VoucherType = $voucherType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Voucher
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Remainder value
     * @return float
     */
    public function getRemainder()
    {
        return $this->Remainder;
    }
    /**
     * Set Remainder value
     * @param float $remainder
     * @return \StructType\Voucher
     */
    public function setRemainder($remainder = null)
    {
        // validation for constraint: float
        if (!is_null($remainder) && !(is_float($remainder) || is_numeric($remainder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remainder, true), gettype($remainder)), __LINE__);
        }
        $this->Remainder = $remainder;
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\Voucher
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Voucher
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get RedeemDate value
     * @return string
     */
    public function getRedeemDate()
    {
        return $this->RedeemDate;
    }
    /**
     * Set RedeemDate value
     * @param string $redeemDate
     * @return \StructType\Voucher
     */
    public function setRedeemDate($redeemDate = null)
    {
        // validation for constraint: string
        if (!is_null($redeemDate) && !is_string($redeemDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redeemDate, true), gettype($redeemDate)), __LINE__);
        }
        $this->RedeemDate = $redeemDate;
        return $this;
    }
    /**
     * Get SalesDate value
     * @return string
     */
    public function getSalesDate()
    {
        return $this->SalesDate;
    }
    /**
     * Set SalesDate value
     * @param string $salesDate
     * @return \StructType\Voucher
     */
    public function setSalesDate($salesDate = null)
    {
        // validation for constraint: string
        if (!is_null($salesDate) && !is_string($salesDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDate, true), gettype($salesDate)), __LINE__);
        }
        $this->SalesDate = $salesDate;
        return $this;
    }
    /**
     * Get LastChange value
     * @return string
     */
    public function getLastChange()
    {
        return $this->LastChange;
    }
    /**
     * Set LastChange value
     * @param string $lastChange
     * @return \StructType\Voucher
     */
    public function setLastChange($lastChange = null)
    {
        // validation for constraint: string
        if (!is_null($lastChange) && !is_string($lastChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChange, true), gettype($lastChange)), __LINE__);
        }
        $this->LastChange = $lastChange;
        return $this;
    }
    /**
     * Get IsRedeemed value
     * @return bool
     */
    public function getIsRedeemed()
    {
        return $this->IsRedeemed;
    }
    /**
     * Set IsRedeemed value
     * @param bool $isRedeemed
     * @return \StructType\Voucher
     */
    public function setIsRedeemed($isRedeemed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRedeemed) && !is_bool($isRedeemed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRedeemed, true), gettype($isRedeemed)), __LINE__);
        }
        $this->IsRedeemed = $isRedeemed;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\Voucher
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get IsPrinted value
     * @return bool
     */
    public function getIsPrinted()
    {
        return $this->IsPrinted;
    }
    /**
     * Set IsPrinted value
     * @param bool $isPrinted
     * @return \StructType\Voucher
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        $this->IsPrinted = $isPrinted;
        return $this;
    }
    /**
     * Get ScanCode value
     * @return string|null
     */
    public function getScanCode()
    {
        return $this->ScanCode;
    }
    /**
     * Set ScanCode value
     * @param string $scanCode
     * @return \StructType\Voucher
     */
    public function setScanCode($scanCode = null)
    {
        // validation for constraint: string
        if (!is_null($scanCode) && !is_string($scanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanCode, true), gettype($scanCode)), __LINE__);
        }
        $this->ScanCode = $scanCode;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\Voucher
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\Voucher
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\Voucher
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\Voucher
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\Voucher
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\Voucher
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
}
