<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIbtResponse StructType
 * @subpackage Structs
 */
class UpdateIbtResponse extends BaseResponse
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The UpdateIbtResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UpdateIbtResponse
     */
    public $UpdateIbtResult;
    /**
     * The StatusMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The Ibt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterBranchTransferHead
     */
    public $Ibt;
    /**
     * Constructor method for UpdateIbtResponse
     * @uses UpdateIbtResponse::setStatus()
     * @uses UpdateIbtResponse::setUpdateIbtResult()
     * @uses UpdateIbtResponse::setStatusMessage()
     * @uses UpdateIbtResponse::setIbt()
     * @param string $status
     * @param \StructType\UpdateIbtResponse $updateIbtResult
     * @param string $statusMessage
     * @param \StructType\InterBranchTransferHead $ibt
     */
    public function __construct($status = null, \StructType\UpdateIbtResponse $updateIbtResult = null, $statusMessage = null, \StructType\InterBranchTransferHead $ibt = null)
    {
        $this
            ->setStatus($status)
            ->setUpdateIbtResult($updateIbtResult)
            ->setStatusMessage($statusMessage)
            ->setIbt($ibt);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\UpdateIbtStatus::valueIsValid()
     * @uses \EnumType\UpdateIbtStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\UpdateIbtResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateIbtStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UpdateIbtStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\UpdateIbtStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get UpdateIbtResult value
     * @return \StructType\UpdateIbtResponse|null
     */
    public function getUpdateIbtResult()
    {
        return $this->UpdateIbtResult;
    }
    /**
     * Set UpdateIbtResult value
     * @param \StructType\UpdateIbtResponse $updateIbtResult
     * @return \StructType\UpdateIbtResponse
     */
    public function setUpdateIbtResult(\StructType\UpdateIbtResponse $updateIbtResult = null)
    {
        $this->UpdateIbtResult = $updateIbtResult;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \StructType\UpdateIbtResponse
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusMessage, true), gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get Ibt value
     * @return \StructType\InterBranchTransferHead|null
     */
    public function getIbt()
    {
        return $this->Ibt;
    }
    /**
     * Set Ibt value
     * @param \StructType\InterBranchTransferHead $ibt
     * @return \StructType\UpdateIbtResponse
     */
    public function setIbt(\StructType\InterBranchTransferHead $ibt = null)
    {
        $this->Ibt = $ibt;
        return $this;
    }
}
