<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shop StructType
 * @subpackage Structs
 */
class Shop extends BaseContract_FullIDSet
{
    /**
     * The ShopName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopName;
    /**
     * The ShopBookingPlace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingPlace
     */
    public $ShopBookingPlace;
    /**
     * Constructor method for Shop
     * @uses Shop::setShopName()
     * @uses Shop::setShopBookingPlace()
     * @param string $shopName
     * @param \StructType\BookingPlace $shopBookingPlace
     */
    public function __construct($shopName = null, \StructType\BookingPlace $shopBookingPlace = null)
    {
        $this
            ->setShopName($shopName)
            ->setShopBookingPlace($shopBookingPlace);
    }
    /**
     * Get ShopName value
     * @return string|null
     */
    public function getShopName()
    {
        return $this->ShopName;
    }
    /**
     * Set ShopName value
     * @param string $shopName
     * @return \StructType\Shop
     */
    public function setShopName($shopName = null)
    {
        // validation for constraint: string
        if (!is_null($shopName) && !is_string($shopName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopName, true), gettype($shopName)), __LINE__);
        }
        $this->ShopName = $shopName;
        return $this;
    }
    /**
     * Get ShopBookingPlace value
     * @return \StructType\BookingPlace|null
     */
    public function getShopBookingPlace()
    {
        return $this->ShopBookingPlace;
    }
    /**
     * Set ShopBookingPlace value
     * @param \StructType\BookingPlace $shopBookingPlace
     * @return \StructType\Shop
     */
    public function setShopBookingPlace(\StructType\BookingPlace $shopBookingPlace = null)
    {
        $this->ShopBookingPlace = $shopBookingPlace;
        return $this;
    }
}
