<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceReference StructType
 * @subpackage Structs
 */
class ServiceReference extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The ReferenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceID;
    /**
     * The ReferenceVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceVersion;
    /**
     * The Configuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ComponentConfiguration
     */
    public $Configuration;
    /**
     * Constructor method for ServiceReference
     * @uses ServiceReference::setStatus()
     * @uses ServiceReference::setReferenceID()
     * @uses ServiceReference::setReferenceVersion()
     * @uses ServiceReference::setConfiguration()
     * @param string $status
     * @param string $referenceID
     * @param string $referenceVersion
     * @param \StructType\ComponentConfiguration $configuration
     */
    public function __construct($status = null, $referenceID = null, $referenceVersion = null, \StructType\ComponentConfiguration $configuration = null)
    {
        $this
            ->setStatus($status)
            ->setReferenceID($referenceID)
            ->setReferenceVersion($referenceVersion)
            ->setConfiguration($configuration);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ComponentStatus::valueIsValid()
     * @uses \EnumType\ComponentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ServiceReference
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComponentStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ComponentStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ComponentStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ReferenceID value
     * @return string|null
     */
    public function getReferenceID()
    {
        return $this->ReferenceID;
    }
    /**
     * Set ReferenceID value
     * @param string $referenceID
     * @return \StructType\ServiceReference
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: string
        if (!is_null($referenceID) && !is_string($referenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceID, true), gettype($referenceID)), __LINE__);
        }
        $this->ReferenceID = $referenceID;
        return $this;
    }
    /**
     * Get ReferenceVersion value
     * @return string|null
     */
    public function getReferenceVersion()
    {
        return $this->ReferenceVersion;
    }
    /**
     * Set ReferenceVersion value
     * @param string $referenceVersion
     * @return \StructType\ServiceReference
     */
    public function setReferenceVersion($referenceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($referenceVersion) && !is_string($referenceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceVersion, true), gettype($referenceVersion)), __LINE__);
        }
        $this->ReferenceVersion = $referenceVersion;
        return $this;
    }
    /**
     * Get Configuration value
     * @return \StructType\ComponentConfiguration|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param \StructType\ComponentConfiguration $configuration
     * @return \StructType\ServiceReference
     */
    public function setConfiguration(\StructType\ComponentConfiguration $configuration = null)
    {
        $this->Configuration = $configuration;
        return $this;
    }
}
