<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendVoucherRequest StructType
 * @subpackage Structs
 */
class SendVoucherRequest extends AbstractStructBase
{
    /**
     * The VoucherType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VoucherType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidFrom;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpirationDate;
    /**
     * The SalesDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesDate;
    /**
     * The RedeemDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RedeemDate;
    /**
     * The Redeemed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Redeemed;
    /**
     * The ReceiptNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptNo;
    /**
     * The ScanCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScanCode;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * Constructor method for SendVoucherRequest
     * @uses SendVoucherRequest::setVoucherType()
     * @uses SendVoucherRequest::setAmount()
     * @uses SendVoucherRequest::setValidFrom()
     * @uses SendVoucherRequest::setExpirationDate()
     * @uses SendVoucherRequest::setSalesDate()
     * @uses SendVoucherRequest::setRedeemDate()
     * @uses SendVoucherRequest::setRedeemed()
     * @uses SendVoucherRequest::setReceiptNo()
     * @uses SendVoucherRequest::setScanCode()
     * @uses SendVoucherRequest::setShopId()
     * @uses SendVoucherRequest::setShopCustomerId()
     * @uses SendVoucherRequest::setCustomerId()
     * @uses SendVoucherRequest::setCurrencyISO()
     * @uses SendVoucherRequest::setInfo()
     * @param string $voucherType
     * @param float $amount
     * @param string $validFrom
     * @param string $expirationDate
     * @param string $salesDate
     * @param string $redeemDate
     * @param bool $redeemed
     * @param string $receiptNo
     * @param string $scanCode
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     * @param string $currencyISO
     * @param string $info
     */
    public function __construct($voucherType = null, $amount = null, $validFrom = null, $expirationDate = null, $salesDate = null, $redeemDate = null, $redeemed = null, $receiptNo = null, $scanCode = null, $shopId = null, $shopCustomerId = null, $customerId = null, $currencyISO = null, $info = null)
    {
        $this
            ->setVoucherType($voucherType)
            ->setAmount($amount)
            ->setValidFrom($validFrom)
            ->setExpirationDate($expirationDate)
            ->setSalesDate($salesDate)
            ->setRedeemDate($redeemDate)
            ->setRedeemed($redeemed)
            ->setReceiptNo($receiptNo)
            ->setScanCode($scanCode)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId)
            ->setCurrencyISO($currencyISO)
            ->setInfo($info);
    }
    /**
     * Get VoucherType value
     * @return string
     */
    public function getVoucherType()
    {
        return $this->VoucherType;
    }
    /**
     * Set VoucherType value
     * @uses \EnumType\VoucherType::valueIsValid()
     * @uses \EnumType\VoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $voucherType
     * @return \StructType\SendVoucherRequest
     */
    public function setVoucherType($voucherType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherType::valueIsValid($voucherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VoucherType', is_array($voucherType) ? implode(', ', $voucherType) : var_export($voucherType, true), implode(', ', \EnumType\VoucherType::getValidValues())), __LINE__);
        }
        $this->VoucherType = $voucherType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SendVoucherRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\SendVoucherRequest
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\SendVoucherRequest
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get SalesDate value
     * @return string
     */
    public function getSalesDate()
    {
        return $this->SalesDate;
    }
    /**
     * Set SalesDate value
     * @param string $salesDate
     * @return \StructType\SendVoucherRequest
     */
    public function setSalesDate($salesDate = null)
    {
        // validation for constraint: string
        if (!is_null($salesDate) && !is_string($salesDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDate, true), gettype($salesDate)), __LINE__);
        }
        $this->SalesDate = $salesDate;
        return $this;
    }
    /**
     * Get RedeemDate value
     * @return string
     */
    public function getRedeemDate()
    {
        return $this->RedeemDate;
    }
    /**
     * Set RedeemDate value
     * @param string $redeemDate
     * @return \StructType\SendVoucherRequest
     */
    public function setRedeemDate($redeemDate = null)
    {
        // validation for constraint: string
        if (!is_null($redeemDate) && !is_string($redeemDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redeemDate, true), gettype($redeemDate)), __LINE__);
        }
        $this->RedeemDate = $redeemDate;
        return $this;
    }
    /**
     * Get Redeemed value
     * @return bool
     */
    public function getRedeemed()
    {
        return $this->Redeemed;
    }
    /**
     * Set Redeemed value
     * @param bool $redeemed
     * @return \StructType\SendVoucherRequest
     */
    public function setRedeemed($redeemed = null)
    {
        // validation for constraint: boolean
        if (!is_null($redeemed) && !is_bool($redeemed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($redeemed, true), gettype($redeemed)), __LINE__);
        }
        $this->Redeemed = $redeemed;
        return $this;
    }
    /**
     * Get ReceiptNo value
     * @return string|null
     */
    public function getReceiptNo()
    {
        return $this->ReceiptNo;
    }
    /**
     * Set ReceiptNo value
     * @param string $receiptNo
     * @return \StructType\SendVoucherRequest
     */
    public function setReceiptNo($receiptNo = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNo) && !is_string($receiptNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptNo, true), gettype($receiptNo)), __LINE__);
        }
        $this->ReceiptNo = $receiptNo;
        return $this;
    }
    /**
     * Get ScanCode value
     * @return string|null
     */
    public function getScanCode()
    {
        return $this->ScanCode;
    }
    /**
     * Set ScanCode value
     * @param string $scanCode
     * @return \StructType\SendVoucherRequest
     */
    public function setScanCode($scanCode = null)
    {
        // validation for constraint: string
        if (!is_null($scanCode) && !is_string($scanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanCode, true), gettype($scanCode)), __LINE__);
        }
        $this->ScanCode = $scanCode;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\SendVoucherRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\SendVoucherRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\SendVoucherRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\SendVoucherRequest
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\SendVoucherRequest
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
}
