<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendStockCorrectionRequest StructType
 * @subpackage Structs
 */
class SendStockCorrectionRequest extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The IsAbsQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAbsQty;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The ReasonText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonText;
    /**
     * The Corrections
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSendStockCorrectionDetailRequest
     */
    public $Corrections;
    /**
     * Constructor method for SendStockCorrectionRequest
     * @uses SendStockCorrectionRequest::setDate()
     * @uses SendStockCorrectionRequest::setIsAbsQty()
     * @uses SendStockCorrectionRequest::setBranchId()
     * @uses SendStockCorrectionRequest::setReasonText()
     * @uses SendStockCorrectionRequest::setCorrections()
     * @param string $date
     * @param bool $isAbsQty
     * @param string $branchId
     * @param string $reasonText
     * @param \ArrayType\ArrayOfSendStockCorrectionDetailRequest $corrections
     */
    public function __construct($date = null, $isAbsQty = null, $branchId = null, $reasonText = null, \ArrayType\ArrayOfSendStockCorrectionDetailRequest $corrections = null)
    {
        $this
            ->setDate($date)
            ->setIsAbsQty($isAbsQty)
            ->setBranchId($branchId)
            ->setReasonText($reasonText)
            ->setCorrections($corrections);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\SendStockCorrectionRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get IsAbsQty value
     * @return bool
     */
    public function getIsAbsQty()
    {
        return $this->IsAbsQty;
    }
    /**
     * Set IsAbsQty value
     * @param bool $isAbsQty
     * @return \StructType\SendStockCorrectionRequest
     */
    public function setIsAbsQty($isAbsQty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAbsQty) && !is_bool($isAbsQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAbsQty, true), gettype($isAbsQty)), __LINE__);
        }
        $this->IsAbsQty = $isAbsQty;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\SendStockCorrectionRequest
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get ReasonText value
     * @return string|null
     */
    public function getReasonText()
    {
        return $this->ReasonText;
    }
    /**
     * Set ReasonText value
     * @param string $reasonText
     * @return \StructType\SendStockCorrectionRequest
     */
    public function setReasonText($reasonText = null)
    {
        // validation for constraint: string
        if (!is_null($reasonText) && !is_string($reasonText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonText, true), gettype($reasonText)), __LINE__);
        }
        $this->ReasonText = $reasonText;
        return $this;
    }
    /**
     * Get Corrections value
     * @return \ArrayType\ArrayOfSendStockCorrectionDetailRequest|null
     */
    public function getCorrections()
    {
        return $this->Corrections;
    }
    /**
     * Set Corrections value
     * @param \ArrayType\ArrayOfSendStockCorrectionDetailRequest $corrections
     * @return \StructType\SendStockCorrectionRequest
     */
    public function setCorrections(\ArrayType\ArrayOfSendStockCorrectionDetailRequest $corrections = null)
    {
        $this->Corrections = $corrections;
        return $this;
    }
}
