<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendSalesReceiptRequest StructType
 * @subpackage Structs
 */
class SendSalesReceiptRequest extends AbstractStructBase
{
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptNumber;
    /**
     * The SalesReceiptTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesReceiptTimestamp;
    /**
     * The ZNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ZNumber;
    /**
     * The CashId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CashId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The SalesReceiptPositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSalesReceiptPosition
     */
    public $SalesReceiptPositions;
    /**
     * Constructor method for SendSalesReceiptRequest
     * @uses SendSalesReceiptRequest::setReceiptNumber()
     * @uses SendSalesReceiptRequest::setSalesReceiptTimestamp()
     * @uses SendSalesReceiptRequest::setZNumber()
     * @uses SendSalesReceiptRequest::setCashId()
     * @uses SendSalesReceiptRequest::setCustomerId()
     * @uses SendSalesReceiptRequest::setSalesReceiptPositions()
     * @param int $receiptNumber
     * @param string $salesReceiptTimestamp
     * @param int $zNumber
     * @param string $cashId
     * @param string $customerId
     * @param \ArrayType\ArrayOfSalesReceiptPosition $salesReceiptPositions
     */
    public function __construct($receiptNumber = null, $salesReceiptTimestamp = null, $zNumber = null, $cashId = null, $customerId = null, \ArrayType\ArrayOfSalesReceiptPosition $salesReceiptPositions = null)
    {
        $this
            ->setReceiptNumber($receiptNumber)
            ->setSalesReceiptTimestamp($salesReceiptTimestamp)
            ->setZNumber($zNumber)
            ->setCashId($cashId)
            ->setCustomerId($customerId)
            ->setSalesReceiptPositions($salesReceiptPositions);
    }
    /**
     * Get ReceiptNumber value
     * @return int
     */
    public function getReceiptNumber()
    {
        return $this->ReceiptNumber;
    }
    /**
     * Set ReceiptNumber value
     * @param int $receiptNumber
     * @return \StructType\SendSalesReceiptRequest
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: int
        if (!is_null($receiptNumber) && !(is_int($receiptNumber) || ctype_digit($receiptNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        $this->ReceiptNumber = $receiptNumber;
        return $this;
    }
    /**
     * Get SalesReceiptTimestamp value
     * @return string
     */
    public function getSalesReceiptTimestamp()
    {
        return $this->SalesReceiptTimestamp;
    }
    /**
     * Set SalesReceiptTimestamp value
     * @param string $salesReceiptTimestamp
     * @return \StructType\SendSalesReceiptRequest
     */
    public function setSalesReceiptTimestamp($salesReceiptTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($salesReceiptTimestamp) && !is_string($salesReceiptTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesReceiptTimestamp, true), gettype($salesReceiptTimestamp)), __LINE__);
        }
        $this->SalesReceiptTimestamp = $salesReceiptTimestamp;
        return $this;
    }
    /**
     * Get ZNumber value
     * @return int
     */
    public function getZNumber()
    {
        return $this->ZNumber;
    }
    /**
     * Set ZNumber value
     * @param int $zNumber
     * @return \StructType\SendSalesReceiptRequest
     */
    public function setZNumber($zNumber = null)
    {
        // validation for constraint: int
        if (!is_null($zNumber) && !(is_int($zNumber) || ctype_digit($zNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zNumber, true), gettype($zNumber)), __LINE__);
        }
        $this->ZNumber = $zNumber;
        return $this;
    }
    /**
     * Get CashId value
     * @return string|null
     */
    public function getCashId()
    {
        return $this->CashId;
    }
    /**
     * Set CashId value
     * @param string $cashId
     * @return \StructType\SendSalesReceiptRequest
     */
    public function setCashId($cashId = null)
    {
        // validation for constraint: string
        if (!is_null($cashId) && !is_string($cashId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cashId, true), gettype($cashId)), __LINE__);
        }
        $this->CashId = $cashId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\SendSalesReceiptRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SalesReceiptPositions value
     * @return \ArrayType\ArrayOfSalesReceiptPosition|null
     */
    public function getSalesReceiptPositions()
    {
        return $this->SalesReceiptPositions;
    }
    /**
     * Set SalesReceiptPositions value
     * @param \ArrayType\ArrayOfSalesReceiptPosition $salesReceiptPositions
     * @return \StructType\SendSalesReceiptRequest
     */
    public function setSalesReceiptPositions(\ArrayType\ArrayOfSalesReceiptPosition $salesReceiptPositions = null)
    {
        $this->SalesReceiptPositions = $salesReceiptPositions;
        return $this;
    }
}
