<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendOrderRequest StructType
 * @subpackage Structs
 */
class SendOrderRequest extends AbstractStructBase
{
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SendOrderAddress
     */
    public $DeliveryAddress;
    /**
     * The InvoiceAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SendOrderAddress
     */
    public $InvoiceAddress;
    /**
     * The OrderPositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSendOrderPosition
     */
    public $OrderPositions;
    /**
     * The AdditionalCosts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSendOrderAdditionalCost
     */
    public $AdditionalCosts;
    /**
     * The PaymentTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTypeID;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The MCardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MCardId;
    /**
     * Constructor method for SendOrderRequest
     * @uses SendOrderRequest::setOrderId()
     * @uses SendOrderRequest::setShopId()
     * @uses SendOrderRequest::setShopCustomerId()
     * @uses SendOrderRequest::setCustomerId()
     * @uses SendOrderRequest::setDeliveryAddress()
     * @uses SendOrderRequest::setInvoiceAddress()
     * @uses SendOrderRequest::setOrderPositions()
     * @uses SendOrderRequest::setAdditionalCosts()
     * @uses SendOrderRequest::setPaymentTypeID()
     * @uses SendOrderRequest::setComment()
     * @uses SendOrderRequest::setMCardId()
     * @param string $orderId
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     * @param \StructType\SendOrderAddress $deliveryAddress
     * @param \StructType\SendOrderAddress $invoiceAddress
     * @param \ArrayType\ArrayOfSendOrderPosition $orderPositions
     * @param \ArrayType\ArrayOfSendOrderAdditionalCost $additionalCosts
     * @param string $paymentTypeID
     * @param string $comment
     * @param string $mCardId
     */
    public function __construct($orderId = null, $shopId = null, $shopCustomerId = null, $customerId = null, \StructType\SendOrderAddress $deliveryAddress = null, \StructType\SendOrderAddress $invoiceAddress = null, \ArrayType\ArrayOfSendOrderPosition $orderPositions = null, \ArrayType\ArrayOfSendOrderAdditionalCost $additionalCosts = null, $paymentTypeID = null, $comment = null, $mCardId = null)
    {
        $this
            ->setOrderId($orderId)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId)
            ->setDeliveryAddress($deliveryAddress)
            ->setInvoiceAddress($invoiceAddress)
            ->setOrderPositions($orderPositions)
            ->setAdditionalCosts($additionalCosts)
            ->setPaymentTypeID($paymentTypeID)
            ->setComment($comment)
            ->setMCardId($mCardId);
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\SendOrderRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\SendOrderRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\SendOrderRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\SendOrderRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \StructType\SendOrderAddress|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \StructType\SendOrderAddress $deliveryAddress
     * @return \StructType\SendOrderRequest
     */
    public function setDeliveryAddress(\StructType\SendOrderAddress $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get InvoiceAddress value
     * @return \StructType\SendOrderAddress|null
     */
    public function getInvoiceAddress()
    {
        return $this->InvoiceAddress;
    }
    /**
     * Set InvoiceAddress value
     * @param \StructType\SendOrderAddress $invoiceAddress
     * @return \StructType\SendOrderRequest
     */
    public function setInvoiceAddress(\StructType\SendOrderAddress $invoiceAddress = null)
    {
        $this->InvoiceAddress = $invoiceAddress;
        return $this;
    }
    /**
     * Get OrderPositions value
     * @return \ArrayType\ArrayOfSendOrderPosition|null
     */
    public function getOrderPositions()
    {
        return $this->OrderPositions;
    }
    /**
     * Set OrderPositions value
     * @param \ArrayType\ArrayOfSendOrderPosition $orderPositions
     * @return \StructType\SendOrderRequest
     */
    public function setOrderPositions(\ArrayType\ArrayOfSendOrderPosition $orderPositions = null)
    {
        $this->OrderPositions = $orderPositions;
        return $this;
    }
    /**
     * Get AdditionalCosts value
     * @return \ArrayType\ArrayOfSendOrderAdditionalCost|null
     */
    public function getAdditionalCosts()
    {
        return $this->AdditionalCosts;
    }
    /**
     * Set AdditionalCosts value
     * @param \ArrayType\ArrayOfSendOrderAdditionalCost $additionalCosts
     * @return \StructType\SendOrderRequest
     */
    public function setAdditionalCosts(\ArrayType\ArrayOfSendOrderAdditionalCost $additionalCosts = null)
    {
        $this->AdditionalCosts = $additionalCosts;
        return $this;
    }
    /**
     * Get PaymentTypeID value
     * @return string|null
     */
    public function getPaymentTypeID()
    {
        return $this->PaymentTypeID;
    }
    /**
     * Set PaymentTypeID value
     * @param string $paymentTypeID
     * @return \StructType\SendOrderRequest
     */
    public function setPaymentTypeID($paymentTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeID) && !is_string($paymentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeID, true), gettype($paymentTypeID)), __LINE__);
        }
        $this->PaymentTypeID = $paymentTypeID;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\SendOrderRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get MCardId value
     * @return string|null
     */
    public function getMCardId()
    {
        return $this->MCardId;
    }
    /**
     * Set MCardId value
     * @param string $mCardId
     * @return \StructType\SendOrderRequest
     */
    public function setMCardId($mCardId = null)
    {
        // validation for constraint: string
        if (!is_null($mCardId) && !is_string($mCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mCardId, true), gettype($mCardId)), __LINE__);
        }
        $this->MCardId = $mCardId;
        return $this;
    }
}
