<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendGoodsInAdviceConfirmationRequest StructType
 * @subpackage Structs
 */
class SendGoodsInAdviceConfirmationRequest extends AbstractStructBase
{
    /**
     * The DeliveryNoteTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryNoteTimestamp;
    /**
     * The DeliveryNoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNoteId;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The Originator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Originator;
    /**
     * The Recipient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recipient;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AdviceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGoodsInAdviceDetailRequest
     */
    public $AdviceDetails;
    /**
     * Constructor method for SendGoodsInAdviceConfirmationRequest
     * @uses SendGoodsInAdviceConfirmationRequest::setDeliveryNoteTimestamp()
     * @uses SendGoodsInAdviceConfirmationRequest::setDeliveryNoteId()
     * @uses SendGoodsInAdviceConfirmationRequest::setDocumentId()
     * @uses SendGoodsInAdviceConfirmationRequest::setOriginator()
     * @uses SendGoodsInAdviceConfirmationRequest::setRecipient()
     * @uses SendGoodsInAdviceConfirmationRequest::setDescription()
     * @uses SendGoodsInAdviceConfirmationRequest::setAdviceDetails()
     * @param string $deliveryNoteTimestamp
     * @param string $deliveryNoteId
     * @param string $documentId
     * @param string $originator
     * @param string $recipient
     * @param string $description
     * @param \ArrayType\ArrayOfGoodsInAdviceDetailRequest $adviceDetails
     */
    public function __construct($deliveryNoteTimestamp = null, $deliveryNoteId = null, $documentId = null, $originator = null, $recipient = null, $description = null, \ArrayType\ArrayOfGoodsInAdviceDetailRequest $adviceDetails = null)
    {
        $this
            ->setDeliveryNoteTimestamp($deliveryNoteTimestamp)
            ->setDeliveryNoteId($deliveryNoteId)
            ->setDocumentId($documentId)
            ->setOriginator($originator)
            ->setRecipient($recipient)
            ->setDescription($description)
            ->setAdviceDetails($adviceDetails);
    }
    /**
     * Get DeliveryNoteTimestamp value
     * @return string
     */
    public function getDeliveryNoteTimestamp()
    {
        return $this->DeliveryNoteTimestamp;
    }
    /**
     * Set DeliveryNoteTimestamp value
     * @param string $deliveryNoteTimestamp
     * @return \StructType\SendGoodsInAdviceConfirmationRequest
     */
    public function setDeliveryNoteTimestamp($deliveryNoteTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteTimestamp) && !is_string($deliveryNoteTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteTimestamp, true), gettype($deliveryNoteTimestamp)), __LINE__);
        }
        $this->DeliveryNoteTimestamp = $deliveryNoteTimestamp;
        return $this;
    }
    /**
     * Get DeliveryNoteId value
     * @return string|null
     */
    public function getDeliveryNoteId()
    {
        return $this->DeliveryNoteId;
    }
    /**
     * Set DeliveryNoteId value
     * @param string $deliveryNoteId
     * @return \StructType\SendGoodsInAdviceConfirmationRequest
     */
    public function setDeliveryNoteId($deliveryNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteId) && !is_string($deliveryNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteId, true), gettype($deliveryNoteId)), __LINE__);
        }
        $this->DeliveryNoteId = $deliveryNoteId;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \StructType\SendGoodsInAdviceConfirmationRequest
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get Originator value
     * @return string|null
     */
    public function getOriginator()
    {
        return $this->Originator;
    }
    /**
     * Set Originator value
     * @param string $originator
     * @return \StructType\SendGoodsInAdviceConfirmationRequest
     */
    public function setOriginator($originator = null)
    {
        // validation for constraint: string
        if (!is_null($originator) && !is_string($originator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originator, true), gettype($originator)), __LINE__);
        }
        $this->Originator = $originator;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param string $recipient
     * @return \StructType\SendGoodsInAdviceConfirmationRequest
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SendGoodsInAdviceConfirmationRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AdviceDetails value
     * @return \ArrayType\ArrayOfGoodsInAdviceDetailRequest|null
     */
    public function getAdviceDetails()
    {
        return $this->AdviceDetails;
    }
    /**
     * Set AdviceDetails value
     * @param \ArrayType\ArrayOfGoodsInAdviceDetailRequest $adviceDetails
     * @return \StructType\SendGoodsInAdviceConfirmationRequest
     */
    public function setAdviceDetails(\ArrayType\ArrayOfGoodsInAdviceDetailRequest $adviceDetails = null)
    {
        $this->AdviceDetails = $adviceDetails;
        return $this;
    }
}
