<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesReceiptPosition StructType
 * @subpackage Structs
 */
class SalesReceiptPosition extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Position;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Value;
    /**
     * The PriceAlteration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceAlteration;
    /**
     * The SalesMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SalesMode;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LineType;
    /**
     * The ProductGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductGroupId;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * The SellerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerId;
    /**
     * The TurnoverId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TurnoverId;
    /**
     * The SerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The Discounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDiscount
     */
    public $Discounts;
    /**
     * The TextInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTextInfo
     */
    public $TextInfos;
    /**
     * Constructor method for SalesReceiptPosition
     * @uses SalesReceiptPosition::setPosition()
     * @uses SalesReceiptPosition::setQuantity()
     * @uses SalesReceiptPosition::setValue()
     * @uses SalesReceiptPosition::setPriceAlteration()
     * @uses SalesReceiptPosition::setSalesMode()
     * @uses SalesReceiptPosition::setLineType()
     * @uses SalesReceiptPosition::setProductGroupId()
     * @uses SalesReceiptPosition::setEAN()
     * @uses SalesReceiptPosition::setCurrencyISO()
     * @uses SalesReceiptPosition::setSellerId()
     * @uses SalesReceiptPosition::setTurnoverId()
     * @uses SalesReceiptPosition::setSerialNumber()
     * @uses SalesReceiptPosition::setDiscounts()
     * @uses SalesReceiptPosition::setTextInfos()
     * @param int $position
     * @param float $quantity
     * @param float $value
     * @param float $priceAlteration
     * @param string $salesMode
     * @param string $lineType
     * @param string $productGroupId
     * @param string $eAN
     * @param string $currencyISO
     * @param string $sellerId
     * @param string $turnoverId
     * @param string $serialNumber
     * @param \ArrayType\ArrayOfDiscount $discounts
     * @param \ArrayType\ArrayOfTextInfo $textInfos
     */
    public function __construct($position = null, $quantity = null, $value = null, $priceAlteration = null, $salesMode = null, $lineType = null, $productGroupId = null, $eAN = null, $currencyISO = null, $sellerId = null, $turnoverId = null, $serialNumber = null, \ArrayType\ArrayOfDiscount $discounts = null, \ArrayType\ArrayOfTextInfo $textInfos = null)
    {
        $this
            ->setPosition($position)
            ->setQuantity($quantity)
            ->setValue($value)
            ->setPriceAlteration($priceAlteration)
            ->setSalesMode($salesMode)
            ->setLineType($lineType)
            ->setProductGroupId($productGroupId)
            ->setEAN($eAN)
            ->setCurrencyISO($currencyISO)
            ->setSellerId($sellerId)
            ->setTurnoverId($turnoverId)
            ->setSerialNumber($serialNumber)
            ->setDiscounts($discounts)
            ->setTextInfos($textInfos);
    }
    /**
     * Get Position value
     * @return int
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\SalesReceiptPosition
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\SalesReceiptPosition
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\SalesReceiptPosition
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get PriceAlteration value
     * @return float
     */
    public function getPriceAlteration()
    {
        return $this->PriceAlteration;
    }
    /**
     * Set PriceAlteration value
     * @param float $priceAlteration
     * @return \StructType\SalesReceiptPosition
     */
    public function setPriceAlteration($priceAlteration = null)
    {
        // validation for constraint: float
        if (!is_null($priceAlteration) && !(is_float($priceAlteration) || is_numeric($priceAlteration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceAlteration, true), gettype($priceAlteration)), __LINE__);
        }
        $this->PriceAlteration = $priceAlteration;
        return $this;
    }
    /**
     * Get SalesMode value
     * @return string
     */
    public function getSalesMode()
    {
        return $this->SalesMode;
    }
    /**
     * Set SalesMode value
     * @uses \EnumType\SalesMode::valueIsValid()
     * @uses \EnumType\SalesMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salesMode
     * @return \StructType\SalesReceiptPosition
     */
    public function setSalesMode($salesMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SalesMode::valueIsValid($salesMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SalesMode', is_array($salesMode) ? implode(', ', $salesMode) : var_export($salesMode, true), implode(', ', \EnumType\SalesMode::getValidValues())), __LINE__);
        }
        $this->SalesMode = $salesMode;
        return $this;
    }
    /**
     * Get LineType value
     * @return string
     */
    public function getLineType()
    {
        return $this->LineType;
    }
    /**
     * Set LineType value
     * @uses \EnumType\LineType::valueIsValid()
     * @uses \EnumType\LineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineType
     * @return \StructType\SalesReceiptPosition
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LineType::valueIsValid($lineType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LineType', is_array($lineType) ? implode(', ', $lineType) : var_export($lineType, true), implode(', ', \EnumType\LineType::getValidValues())), __LINE__);
        }
        $this->LineType = $lineType;
        return $this;
    }
    /**
     * Get ProductGroupId value
     * @return string|null
     */
    public function getProductGroupId()
    {
        return $this->ProductGroupId;
    }
    /**
     * Set ProductGroupId value
     * @param string $productGroupId
     * @return \StructType\SalesReceiptPosition
     */
    public function setProductGroupId($productGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupId) && !is_string($productGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroupId, true), gettype($productGroupId)), __LINE__);
        }
        $this->ProductGroupId = $productGroupId;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\SalesReceiptPosition
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\SalesReceiptPosition
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get SellerId value
     * @return string|null
     */
    public function getSellerId()
    {
        return $this->SellerId;
    }
    /**
     * Set SellerId value
     * @param string $sellerId
     * @return \StructType\SalesReceiptPosition
     */
    public function setSellerId($sellerId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerId) && !is_string($sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerId, true), gettype($sellerId)), __LINE__);
        }
        $this->SellerId = $sellerId;
        return $this;
    }
    /**
     * Get TurnoverId value
     * @return string|null
     */
    public function getTurnoverId()
    {
        return $this->TurnoverId;
    }
    /**
     * Set TurnoverId value
     * @param string $turnoverId
     * @return \StructType\SalesReceiptPosition
     */
    public function setTurnoverId($turnoverId = null)
    {
        // validation for constraint: string
        if (!is_null($turnoverId) && !is_string($turnoverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnoverId, true), gettype($turnoverId)), __LINE__);
        }
        $this->TurnoverId = $turnoverId;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \StructType\SalesReceiptPosition
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get Discounts value
     * @return \ArrayType\ArrayOfDiscount|null
     */
    public function getDiscounts()
    {
        return $this->Discounts;
    }
    /**
     * Set Discounts value
     * @param \ArrayType\ArrayOfDiscount $discounts
     * @return \StructType\SalesReceiptPosition
     */
    public function setDiscounts(\ArrayType\ArrayOfDiscount $discounts = null)
    {
        $this->Discounts = $discounts;
        return $this;
    }
    /**
     * Get TextInfos value
     * @return \ArrayType\ArrayOfTextInfo|null
     */
    public function getTextInfos()
    {
        return $this->TextInfos;
    }
    /**
     * Set TextInfos value
     * @param \ArrayType\ArrayOfTextInfo $textInfos
     * @return \StructType\SalesReceiptPosition
     */
    public function setTextInfos(\ArrayType\ArrayOfTextInfo $textInfos = null)
    {
        $this->TextInfos = $textInfos;
        return $this;
    }
}
