<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnReason StructType
 * @subpackage Structs
 */
class ReturnReason extends BaseContract_FullIDSet
{
    /**
     * The LastReceiptNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LastReceiptNumber;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The BranchID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchID;
    /**
     * Constructor method for ReturnReason
     * @uses ReturnReason::setLastReceiptNumber()
     * @uses ReturnReason::setIsActive()
     * @uses ReturnReason::setDescription()
     * @uses ReturnReason::setBranchID()
     * @param int $lastReceiptNumber
     * @param bool $isActive
     * @param string $description
     * @param string $branchID
     */
    public function __construct($lastReceiptNumber = null, $isActive = null, $description = null, $branchID = null)
    {
        $this
            ->setLastReceiptNumber($lastReceiptNumber)
            ->setIsActive($isActive)
            ->setDescription($description)
            ->setBranchID($branchID);
    }
    /**
     * Get LastReceiptNumber value
     * @return int
     */
    public function getLastReceiptNumber()
    {
        return $this->LastReceiptNumber;
    }
    /**
     * Set LastReceiptNumber value
     * @param int $lastReceiptNumber
     * @return \StructType\ReturnReason
     */
    public function setLastReceiptNumber($lastReceiptNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lastReceiptNumber) && !(is_int($lastReceiptNumber) || ctype_digit($lastReceiptNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastReceiptNumber, true), gettype($lastReceiptNumber)), __LINE__);
        }
        $this->LastReceiptNumber = $lastReceiptNumber;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\ReturnReason
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ReturnReason
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BranchID value
     * @return string|null
     */
    public function getBranchID()
    {
        return $this->BranchID;
    }
    /**
     * Set BranchID value
     * @param string $branchID
     * @return \StructType\ReturnReason
     */
    public function setBranchID($branchID = null)
    {
        // validation for constraint: string
        if (!is_null($branchID) && !is_string($branchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchID, true), gettype($branchID)), __LINE__);
        }
        $this->BranchID = $branchID;
        return $this;
    }
}
