<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductGroup StructType
 * @subpackage Structs
 */
class ProductGroup extends BaseContract_FullIDSet
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Number;
    /**
     * The VatTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VatTypeId;
    /**
     * The IsLeaf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLeaf;
    /**
     * The IsSelectionPermitted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSelectionPermitted;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortDescription;
    /**
     * The ParentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentID;
    /**
     * The ParentProductGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductGroup
     */
    public $ParentProductGroup;
    /**
     * The ChildProductGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductGroup
     */
    public $ChildProductGroups;
    /**
     * Constructor method for ProductGroup
     * @uses ProductGroup::setNumber()
     * @uses ProductGroup::setVatTypeId()
     * @uses ProductGroup::setIsLeaf()
     * @uses ProductGroup::setIsSelectionPermitted()
     * @uses ProductGroup::setDescription()
     * @uses ProductGroup::setShortDescription()
     * @uses ProductGroup::setParentID()
     * @uses ProductGroup::setParentProductGroup()
     * @uses ProductGroup::setChildProductGroups()
     * @param int $number
     * @param int $vatTypeId
     * @param bool $isLeaf
     * @param bool $isSelectionPermitted
     * @param string $description
     * @param string $shortDescription
     * @param string $parentID
     * @param \StructType\ProductGroup $parentProductGroup
     * @param \ArrayType\ArrayOfProductGroup $childProductGroups
     */
    public function __construct($number = null, $vatTypeId = null, $isLeaf = null, $isSelectionPermitted = null, $description = null, $shortDescription = null, $parentID = null, \StructType\ProductGroup $parentProductGroup = null, \ArrayType\ArrayOfProductGroup $childProductGroups = null)
    {
        $this
            ->setNumber($number)
            ->setVatTypeId($vatTypeId)
            ->setIsLeaf($isLeaf)
            ->setIsSelectionPermitted($isSelectionPermitted)
            ->setDescription($description)
            ->setShortDescription($shortDescription)
            ->setParentID($parentID)
            ->setParentProductGroup($parentProductGroup)
            ->setChildProductGroups($childProductGroups);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\ProductGroup
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get VatTypeId value
     * @return int
     */
    public function getVatTypeId()
    {
        return $this->VatTypeId;
    }
    /**
     * Set VatTypeId value
     * @param int $vatTypeId
     * @return \StructType\ProductGroup
     */
    public function setVatTypeId($vatTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($vatTypeId) && !(is_int($vatTypeId) || ctype_digit($vatTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatTypeId, true), gettype($vatTypeId)), __LINE__);
        }
        $this->VatTypeId = $vatTypeId;
        return $this;
    }
    /**
     * Get IsLeaf value
     * @return bool
     */
    public function getIsLeaf()
    {
        return $this->IsLeaf;
    }
    /**
     * Set IsLeaf value
     * @param bool $isLeaf
     * @return \StructType\ProductGroup
     */
    public function setIsLeaf($isLeaf = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLeaf) && !is_bool($isLeaf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLeaf, true), gettype($isLeaf)), __LINE__);
        }
        $this->IsLeaf = $isLeaf;
        return $this;
    }
    /**
     * Get IsSelectionPermitted value
     * @return bool
     */
    public function getIsSelectionPermitted()
    {
        return $this->IsSelectionPermitted;
    }
    /**
     * Set IsSelectionPermitted value
     * @param bool $isSelectionPermitted
     * @return \StructType\ProductGroup
     */
    public function setIsSelectionPermitted($isSelectionPermitted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelectionPermitted) && !is_bool($isSelectionPermitted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelectionPermitted, true), gettype($isSelectionPermitted)), __LINE__);
        }
        $this->IsSelectionPermitted = $isSelectionPermitted;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ProductGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \StructType\ProductGroup
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get ParentID value
     * @return string|null
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param string $parentID
     * @return \StructType\ProductGroup
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: string
        if (!is_null($parentID) && !is_string($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentID, true), gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get ParentProductGroup value
     * @return \StructType\ProductGroup|null
     */
    public function getParentProductGroup()
    {
        return $this->ParentProductGroup;
    }
    /**
     * Set ParentProductGroup value
     * @param \StructType\ProductGroup $parentProductGroup
     * @return \StructType\ProductGroup
     */
    public function setParentProductGroup(\StructType\ProductGroup $parentProductGroup = null)
    {
        $this->ParentProductGroup = $parentProductGroup;
        return $this;
    }
    /**
     * Get ChildProductGroups value
     * @return \ArrayType\ArrayOfProductGroup|null
     */
    public function getChildProductGroups()
    {
        return $this->ChildProductGroups;
    }
    /**
     * Set ChildProductGroups value
     * @param \ArrayType\ArrayOfProductGroup $childProductGroups
     * @return \StructType\ProductGroup
     */
    public function setChildProductGroups(\ArrayType\ArrayOfProductGroup $childProductGroups = null)
    {
        $this->ChildProductGroups = $childProductGroups;
        return $this;
    }
}
