<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentType StructType
 * @subpackage Structs
 */
class PaymentType extends BaseContract_FullIDSet
{
    /**
     * The NoBonus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoBonus;
    /**
     * The NoDrawer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoDrawer;
    /**
     * The NoStandardPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoStandardPayment;
    /**
     * The ShowOnReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowOnReport;
    /**
     * The PrintOnReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PrintOnReport;
    /**
     * The OnlinePayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OnlinePayment;
    /**
     * The SpecialPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SpecialPayment;
    /**
     * The WarningLimit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WarningLimit;
    /**
     * The WarningAction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WarningAction;
    /**
     * The MaximumLimit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaximumLimit;
    /**
     * The GiftVoucherDiscVatKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GiftVoucherDiscVatKey;
    /**
     * The OverPaymentMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OverPaymentMode;
    /**
     * The ReportMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReportMode;
    /**
     * The RoundingMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RoundingMode;
    /**
     * The RoundingValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RoundingValue;
    /**
     * The CustomerRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CustomerRequired;
    /**
     * The SerialNoMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SerialNoMode;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IncomingDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IncomingDirection;
    /**
     * The OnlineMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OnlineMethod;
    /**
     * The OnlineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OnlineType;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountId;
    /**
     * The WarningText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarningText;
    /**
     * The MaximumText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaximumText;
    /**
     * The GiftVoucherDiscountAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GiftVoucherDiscountAccount;
    /**
     * The DiffAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiffAccount;
    /**
     * Constructor method for PaymentType
     * @uses PaymentType::setNoBonus()
     * @uses PaymentType::setNoDrawer()
     * @uses PaymentType::setNoStandardPayment()
     * @uses PaymentType::setShowOnReport()
     * @uses PaymentType::setPrintOnReport()
     * @uses PaymentType::setOnlinePayment()
     * @uses PaymentType::setSpecialPayment()
     * @uses PaymentType::setWarningLimit()
     * @uses PaymentType::setWarningAction()
     * @uses PaymentType::setMaximumLimit()
     * @uses PaymentType::setGiftVoucherDiscVatKey()
     * @uses PaymentType::setOverPaymentMode()
     * @uses PaymentType::setReportMode()
     * @uses PaymentType::setRoundingMode()
     * @uses PaymentType::setRoundingValue()
     * @uses PaymentType::setCustomerRequired()
     * @uses PaymentType::setSerialNoMode()
     * @uses PaymentType::setCurrencyISO()
     * @uses PaymentType::setDescription()
     * @uses PaymentType::setIncomingDirection()
     * @uses PaymentType::setOnlineMethod()
     * @uses PaymentType::setOnlineType()
     * @uses PaymentType::setAccountId()
     * @uses PaymentType::setWarningText()
     * @uses PaymentType::setMaximumText()
     * @uses PaymentType::setGiftVoucherDiscountAccount()
     * @uses PaymentType::setDiffAccount()
     * @param bool $noBonus
     * @param bool $noDrawer
     * @param bool $noStandardPayment
     * @param bool $showOnReport
     * @param bool $printOnReport
     * @param bool $onlinePayment
     * @param string $specialPayment
     * @param float $warningLimit
     * @param string $warningAction
     * @param float $maximumLimit
     * @param int $giftVoucherDiscVatKey
     * @param string $overPaymentMode
     * @param string $reportMode
     * @param string $roundingMode
     * @param float $roundingValue
     * @param bool $customerRequired
     * @param string $serialNoMode
     * @param string $currencyISO
     * @param string $description
     * @param string $incomingDirection
     * @param string $onlineMethod
     * @param string $onlineType
     * @param string $accountId
     * @param string $warningText
     * @param string $maximumText
     * @param string $giftVoucherDiscountAccount
     * @param string $diffAccount
     */
    public function __construct($noBonus = null, $noDrawer = null, $noStandardPayment = null, $showOnReport = null, $printOnReport = null, $onlinePayment = null, $specialPayment = null, $warningLimit = null, $warningAction = null, $maximumLimit = null, $giftVoucherDiscVatKey = null, $overPaymentMode = null, $reportMode = null, $roundingMode = null, $roundingValue = null, $customerRequired = null, $serialNoMode = null, $currencyISO = null, $description = null, $incomingDirection = null, $onlineMethod = null, $onlineType = null, $accountId = null, $warningText = null, $maximumText = null, $giftVoucherDiscountAccount = null, $diffAccount = null)
    {
        $this
            ->setNoBonus($noBonus)
            ->setNoDrawer($noDrawer)
            ->setNoStandardPayment($noStandardPayment)
            ->setShowOnReport($showOnReport)
            ->setPrintOnReport($printOnReport)
            ->setOnlinePayment($onlinePayment)
            ->setSpecialPayment($specialPayment)
            ->setWarningLimit($warningLimit)
            ->setWarningAction($warningAction)
            ->setMaximumLimit($maximumLimit)
            ->setGiftVoucherDiscVatKey($giftVoucherDiscVatKey)
            ->setOverPaymentMode($overPaymentMode)
            ->setReportMode($reportMode)
            ->setRoundingMode($roundingMode)
            ->setRoundingValue($roundingValue)
            ->setCustomerRequired($customerRequired)
            ->setSerialNoMode($serialNoMode)
            ->setCurrencyISO($currencyISO)
            ->setDescription($description)
            ->setIncomingDirection($incomingDirection)
            ->setOnlineMethod($onlineMethod)
            ->setOnlineType($onlineType)
            ->setAccountId($accountId)
            ->setWarningText($warningText)
            ->setMaximumText($maximumText)
            ->setGiftVoucherDiscountAccount($giftVoucherDiscountAccount)
            ->setDiffAccount($diffAccount);
    }
    /**
     * Get NoBonus value
     * @return bool
     */
    public function getNoBonus()
    {
        return $this->NoBonus;
    }
    /**
     * Set NoBonus value
     * @param bool $noBonus
     * @return \StructType\PaymentType
     */
    public function setNoBonus($noBonus = null)
    {
        // validation for constraint: boolean
        if (!is_null($noBonus) && !is_bool($noBonus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noBonus, true), gettype($noBonus)), __LINE__);
        }
        $this->NoBonus = $noBonus;
        return $this;
    }
    /**
     * Get NoDrawer value
     * @return bool
     */
    public function getNoDrawer()
    {
        return $this->NoDrawer;
    }
    /**
     * Set NoDrawer value
     * @param bool $noDrawer
     * @return \StructType\PaymentType
     */
    public function setNoDrawer($noDrawer = null)
    {
        // validation for constraint: boolean
        if (!is_null($noDrawer) && !is_bool($noDrawer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noDrawer, true), gettype($noDrawer)), __LINE__);
        }
        $this->NoDrawer = $noDrawer;
        return $this;
    }
    /**
     * Get NoStandardPayment value
     * @return bool
     */
    public function getNoStandardPayment()
    {
        return $this->NoStandardPayment;
    }
    /**
     * Set NoStandardPayment value
     * @param bool $noStandardPayment
     * @return \StructType\PaymentType
     */
    public function setNoStandardPayment($noStandardPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($noStandardPayment) && !is_bool($noStandardPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noStandardPayment, true), gettype($noStandardPayment)), __LINE__);
        }
        $this->NoStandardPayment = $noStandardPayment;
        return $this;
    }
    /**
     * Get ShowOnReport value
     * @return bool
     */
    public function getShowOnReport()
    {
        return $this->ShowOnReport;
    }
    /**
     * Set ShowOnReport value
     * @param bool $showOnReport
     * @return \StructType\PaymentType
     */
    public function setShowOnReport($showOnReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnReport) && !is_bool($showOnReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnReport, true), gettype($showOnReport)), __LINE__);
        }
        $this->ShowOnReport = $showOnReport;
        return $this;
    }
    /**
     * Get PrintOnReport value
     * @return bool
     */
    public function getPrintOnReport()
    {
        return $this->PrintOnReport;
    }
    /**
     * Set PrintOnReport value
     * @param bool $printOnReport
     * @return \StructType\PaymentType
     */
    public function setPrintOnReport($printOnReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($printOnReport) && !is_bool($printOnReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printOnReport, true), gettype($printOnReport)), __LINE__);
        }
        $this->PrintOnReport = $printOnReport;
        return $this;
    }
    /**
     * Get OnlinePayment value
     * @return bool
     */
    public function getOnlinePayment()
    {
        return $this->OnlinePayment;
    }
    /**
     * Set OnlinePayment value
     * @param bool $onlinePayment
     * @return \StructType\PaymentType
     */
    public function setOnlinePayment($onlinePayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlinePayment) && !is_bool($onlinePayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlinePayment, true), gettype($onlinePayment)), __LINE__);
        }
        $this->OnlinePayment = $onlinePayment;
        return $this;
    }
    /**
     * Get SpecialPayment value
     * @return string
     */
    public function getSpecialPayment()
    {
        return $this->SpecialPayment;
    }
    /**
     * Set SpecialPayment value
     * @uses \EnumType\SpecialPayment::valueIsValid()
     * @uses \EnumType\SpecialPayment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $specialPayment
     * @return \StructType\PaymentType
     */
    public function setSpecialPayment($specialPayment = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SpecialPayment::valueIsValid($specialPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SpecialPayment', is_array($specialPayment) ? implode(', ', $specialPayment) : var_export($specialPayment, true), implode(', ', \EnumType\SpecialPayment::getValidValues())), __LINE__);
        }
        $this->SpecialPayment = $specialPayment;
        return $this;
    }
    /**
     * Get WarningLimit value
     * @return float
     */
    public function getWarningLimit()
    {
        return $this->WarningLimit;
    }
    /**
     * Set WarningLimit value
     * @param float $warningLimit
     * @return \StructType\PaymentType
     */
    public function setWarningLimit($warningLimit = null)
    {
        // validation for constraint: float
        if (!is_null($warningLimit) && !(is_float($warningLimit) || is_numeric($warningLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($warningLimit, true), gettype($warningLimit)), __LINE__);
        }
        $this->WarningLimit = $warningLimit;
        return $this;
    }
    /**
     * Get WarningAction value
     * @return string
     */
    public function getWarningAction()
    {
        return $this->WarningAction;
    }
    /**
     * Set WarningAction value
     * @uses \EnumType\WarningAction::valueIsValid()
     * @uses \EnumType\WarningAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $warningAction
     * @return \StructType\PaymentType
     */
    public function setWarningAction($warningAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WarningAction::valueIsValid($warningAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WarningAction', is_array($warningAction) ? implode(', ', $warningAction) : var_export($warningAction, true), implode(', ', \EnumType\WarningAction::getValidValues())), __LINE__);
        }
        $this->WarningAction = $warningAction;
        return $this;
    }
    /**
     * Get MaximumLimit value
     * @return float
     */
    public function getMaximumLimit()
    {
        return $this->MaximumLimit;
    }
    /**
     * Set MaximumLimit value
     * @param float $maximumLimit
     * @return \StructType\PaymentType
     */
    public function setMaximumLimit($maximumLimit = null)
    {
        // validation for constraint: float
        if (!is_null($maximumLimit) && !(is_float($maximumLimit) || is_numeric($maximumLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumLimit, true), gettype($maximumLimit)), __LINE__);
        }
        $this->MaximumLimit = $maximumLimit;
        return $this;
    }
    /**
     * Get GiftVoucherDiscVatKey value
     * @return int
     */
    public function getGiftVoucherDiscVatKey()
    {
        return $this->GiftVoucherDiscVatKey;
    }
    /**
     * Set GiftVoucherDiscVatKey value
     * @param int $giftVoucherDiscVatKey
     * @return \StructType\PaymentType
     */
    public function setGiftVoucherDiscVatKey($giftVoucherDiscVatKey = null)
    {
        // validation for constraint: int
        if (!is_null($giftVoucherDiscVatKey) && !(is_int($giftVoucherDiscVatKey) || ctype_digit($giftVoucherDiscVatKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($giftVoucherDiscVatKey, true), gettype($giftVoucherDiscVatKey)), __LINE__);
        }
        $this->GiftVoucherDiscVatKey = $giftVoucherDiscVatKey;
        return $this;
    }
    /**
     * Get OverPaymentMode value
     * @return string
     */
    public function getOverPaymentMode()
    {
        return $this->OverPaymentMode;
    }
    /**
     * Set OverPaymentMode value
     * @uses \EnumType\OverPaymentMode::valueIsValid()
     * @uses \EnumType\OverPaymentMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overPaymentMode
     * @return \StructType\PaymentType
     */
    public function setOverPaymentMode($overPaymentMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OverPaymentMode::valueIsValid($overPaymentMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OverPaymentMode', is_array($overPaymentMode) ? implode(', ', $overPaymentMode) : var_export($overPaymentMode, true), implode(', ', \EnumType\OverPaymentMode::getValidValues())), __LINE__);
        }
        $this->OverPaymentMode = $overPaymentMode;
        return $this;
    }
    /**
     * Get ReportMode value
     * @return string
     */
    public function getReportMode()
    {
        return $this->ReportMode;
    }
    /**
     * Set ReportMode value
     * @uses \EnumType\ReportMode::valueIsValid()
     * @uses \EnumType\ReportMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportMode
     * @return \StructType\PaymentType
     */
    public function setReportMode($reportMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportMode::valueIsValid($reportMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportMode', is_array($reportMode) ? implode(', ', $reportMode) : var_export($reportMode, true), implode(', ', \EnumType\ReportMode::getValidValues())), __LINE__);
        }
        $this->ReportMode = $reportMode;
        return $this;
    }
    /**
     * Get RoundingMode value
     * @return string
     */
    public function getRoundingMode()
    {
        return $this->RoundingMode;
    }
    /**
     * Set RoundingMode value
     * @uses \EnumType\RoundingMode::valueIsValid()
     * @uses \EnumType\RoundingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roundingMode
     * @return \StructType\PaymentType
     */
    public function setRoundingMode($roundingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoundingMode::valueIsValid($roundingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RoundingMode', is_array($roundingMode) ? implode(', ', $roundingMode) : var_export($roundingMode, true), implode(', ', \EnumType\RoundingMode::getValidValues())), __LINE__);
        }
        $this->RoundingMode = $roundingMode;
        return $this;
    }
    /**
     * Get RoundingValue value
     * @return float
     */
    public function getRoundingValue()
    {
        return $this->RoundingValue;
    }
    /**
     * Set RoundingValue value
     * @param float $roundingValue
     * @return \StructType\PaymentType
     */
    public function setRoundingValue($roundingValue = null)
    {
        // validation for constraint: float
        if (!is_null($roundingValue) && !(is_float($roundingValue) || is_numeric($roundingValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($roundingValue, true), gettype($roundingValue)), __LINE__);
        }
        $this->RoundingValue = $roundingValue;
        return $this;
    }
    /**
     * Get CustomerRequired value
     * @return bool
     */
    public function getCustomerRequired()
    {
        return $this->CustomerRequired;
    }
    /**
     * Set CustomerRequired value
     * @param bool $customerRequired
     * @return \StructType\PaymentType
     */
    public function setCustomerRequired($customerRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerRequired) && !is_bool($customerRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerRequired, true), gettype($customerRequired)), __LINE__);
        }
        $this->CustomerRequired = $customerRequired;
        return $this;
    }
    /**
     * Get SerialNoMode value
     * @return string
     */
    public function getSerialNoMode()
    {
        return $this->SerialNoMode;
    }
    /**
     * Set SerialNoMode value
     * @uses \EnumType\SerialNoMode::valueIsValid()
     * @uses \EnumType\SerialNoMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serialNoMode
     * @return \StructType\PaymentType
     */
    public function setSerialNoMode($serialNoMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SerialNoMode::valueIsValid($serialNoMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SerialNoMode', is_array($serialNoMode) ? implode(', ', $serialNoMode) : var_export($serialNoMode, true), implode(', ', \EnumType\SerialNoMode::getValidValues())), __LINE__);
        }
        $this->SerialNoMode = $serialNoMode;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\PaymentType
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PaymentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IncomingDirection value
     * @return string|null
     */
    public function getIncomingDirection()
    {
        return $this->IncomingDirection;
    }
    /**
     * Set IncomingDirection value
     * @param string $incomingDirection
     * @return \StructType\PaymentType
     */
    public function setIncomingDirection($incomingDirection = null)
    {
        // validation for constraint: string
        if (!is_null($incomingDirection) && !is_string($incomingDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomingDirection, true), gettype($incomingDirection)), __LINE__);
        }
        $this->IncomingDirection = $incomingDirection;
        return $this;
    }
    /**
     * Get OnlineMethod value
     * @return string|null
     */
    public function getOnlineMethod()
    {
        return $this->OnlineMethod;
    }
    /**
     * Set OnlineMethod value
     * @param string $onlineMethod
     * @return \StructType\PaymentType
     */
    public function setOnlineMethod($onlineMethod = null)
    {
        // validation for constraint: string
        if (!is_null($onlineMethod) && !is_string($onlineMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineMethod, true), gettype($onlineMethod)), __LINE__);
        }
        $this->OnlineMethod = $onlineMethod;
        return $this;
    }
    /**
     * Get OnlineType value
     * @return string|null
     */
    public function getOnlineType()
    {
        return $this->OnlineType;
    }
    /**
     * Set OnlineType value
     * @param string $onlineType
     * @return \StructType\PaymentType
     */
    public function setOnlineType($onlineType = null)
    {
        // validation for constraint: string
        if (!is_null($onlineType) && !is_string($onlineType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineType, true), gettype($onlineType)), __LINE__);
        }
        $this->OnlineType = $onlineType;
        return $this;
    }
    /**
     * Get AccountId value
     * @return string|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param string $accountId
     * @return \StructType\PaymentType
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get WarningText value
     * @return string|null
     */
    public function getWarningText()
    {
        return $this->WarningText;
    }
    /**
     * Set WarningText value
     * @param string $warningText
     * @return \StructType\PaymentType
     */
    public function setWarningText($warningText = null)
    {
        // validation for constraint: string
        if (!is_null($warningText) && !is_string($warningText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningText, true), gettype($warningText)), __LINE__);
        }
        $this->WarningText = $warningText;
        return $this;
    }
    /**
     * Get MaximumText value
     * @return string|null
     */
    public function getMaximumText()
    {
        return $this->MaximumText;
    }
    /**
     * Set MaximumText value
     * @param string $maximumText
     * @return \StructType\PaymentType
     */
    public function setMaximumText($maximumText = null)
    {
        // validation for constraint: string
        if (!is_null($maximumText) && !is_string($maximumText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumText, true), gettype($maximumText)), __LINE__);
        }
        $this->MaximumText = $maximumText;
        return $this;
    }
    /**
     * Get GiftVoucherDiscountAccount value
     * @return string|null
     */
    public function getGiftVoucherDiscountAccount()
    {
        return $this->GiftVoucherDiscountAccount;
    }
    /**
     * Set GiftVoucherDiscountAccount value
     * @param string $giftVoucherDiscountAccount
     * @return \StructType\PaymentType
     */
    public function setGiftVoucherDiscountAccount($giftVoucherDiscountAccount = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDiscountAccount) && !is_string($giftVoucherDiscountAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDiscountAccount, true), gettype($giftVoucherDiscountAccount)), __LINE__);
        }
        $this->GiftVoucherDiscountAccount = $giftVoucherDiscountAccount;
        return $this;
    }
    /**
     * Get DiffAccount value
     * @return string|null
     */
    public function getDiffAccount()
    {
        return $this->DiffAccount;
    }
    /**
     * Set DiffAccount value
     * @param string $diffAccount
     * @return \StructType\PaymentType
     */
    public function setDiffAccount($diffAccount = null)
    {
        // validation for constraint: string
        if (!is_null($diffAccount) && !is_string($diffAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($diffAccount, true), gettype($diffAccount)), __LINE__);
        }
        $this->DiffAccount = $diffAccount;
        return $this;
    }
}
