<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStock StructType
 * @subpackage Structs
 */
class OrderStock extends AbstractStructBase
{
    /**
     * The OrderStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderStatus;
    /**
     * The DeliveryStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryStatus;
    /**
     * The OrderedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OrderedQuantity;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The OrderStockPositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderStockPosition
     */
    public $OrderStockPositions;
    /**
     * Constructor method for OrderStock
     * @uses OrderStock::setOrderStatus()
     * @uses OrderStock::setDeliveryStatus()
     * @uses OrderStock::setOrderedQuantity()
     * @uses OrderStock::setOrderId()
     * @uses OrderStock::setBranchId()
     * @uses OrderStock::setOrderStockPositions()
     * @param string $orderStatus
     * @param string $deliveryStatus
     * @param float $orderedQuantity
     * @param string $orderId
     * @param string $branchId
     * @param \ArrayType\ArrayOfOrderStockPosition $orderStockPositions
     */
    public function __construct($orderStatus = null, $deliveryStatus = null, $orderedQuantity = null, $orderId = null, $branchId = null, \ArrayType\ArrayOfOrderStockPosition $orderStockPositions = null)
    {
        $this
            ->setOrderStatus($orderStatus)
            ->setDeliveryStatus($deliveryStatus)
            ->setOrderedQuantity($orderedQuantity)
            ->setOrderId($orderId)
            ->setBranchId($branchId)
            ->setOrderStockPositions($orderStockPositions);
    }
    /**
     * Get OrderStatus value
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @uses \EnumType\OrderStatus::valueIsValid()
     * @uses \EnumType\OrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\OrderStock
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderStatus::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderStatus', is_array($orderStatus) ? implode(', ', $orderStatus) : var_export($orderStatus, true), implode(', ', \EnumType\OrderStatus::getValidValues())), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get DeliveryStatus value
     * @return string
     */
    public function getDeliveryStatus()
    {
        return $this->DeliveryStatus;
    }
    /**
     * Set DeliveryStatus value
     * @uses \EnumType\DeliveryStatus::valueIsValid()
     * @uses \EnumType\DeliveryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryStatus
     * @return \StructType\OrderStock
     */
    public function setDeliveryStatus($deliveryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryStatus::valueIsValid($deliveryStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveryStatus', is_array($deliveryStatus) ? implode(', ', $deliveryStatus) : var_export($deliveryStatus, true), implode(', ', \EnumType\DeliveryStatus::getValidValues())), __LINE__);
        }
        $this->DeliveryStatus = $deliveryStatus;
        return $this;
    }
    /**
     * Get OrderedQuantity value
     * @return float
     */
    public function getOrderedQuantity()
    {
        return $this->OrderedQuantity;
    }
    /**
     * Set OrderedQuantity value
     * @param float $orderedQuantity
     * @return \StructType\OrderStock
     */
    public function setOrderedQuantity($orderedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($orderedQuantity) && !(is_float($orderedQuantity) || is_numeric($orderedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderedQuantity, true), gettype($orderedQuantity)), __LINE__);
        }
        $this->OrderedQuantity = $orderedQuantity;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\OrderStock
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\OrderStock
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get OrderStockPositions value
     * @return \ArrayType\ArrayOfOrderStockPosition|null
     */
    public function getOrderStockPositions()
    {
        return $this->OrderStockPositions;
    }
    /**
     * Set OrderStockPositions value
     * @param \ArrayType\ArrayOfOrderStockPosition $orderStockPositions
     * @return \StructType\OrderStock
     */
    public function setOrderStockPositions(\ArrayType\ArrayOfOrderStockPosition $orderStockPositions = null)
    {
        $this->OrderStockPositions = $orderStockPositions;
        return $this;
    }
}
