<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderRequest StructType
 * @subpackage Structs
 */
class OrderRequest extends BaseIterationRequest
{
    /**
     * The ChangedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedSinceDate;
    /**
     * The ResponseDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseDetails;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * Constructor method for OrderRequest
     * @uses OrderRequest::setChangedSinceDate()
     * @uses OrderRequest::setResponseDetails()
     * @uses OrderRequest::setOrderId()
     * @uses OrderRequest::setShopId()
     * @uses OrderRequest::setShopCustomerId()
     * @uses OrderRequest::setCustomerId()
     * @param string $changedSinceDate
     * @param string $responseDetails
     * @param string $orderId
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     */
    public function __construct($changedSinceDate = null, $responseDetails = null, $orderId = null, $shopId = null, $shopCustomerId = null, $customerId = null)
    {
        $this
            ->setChangedSinceDate($changedSinceDate)
            ->setResponseDetails($responseDetails)
            ->setOrderId($orderId)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId);
    }
    /**
     * Get ChangedSinceDate value
     * @return string
     */
    public function getChangedSinceDate()
    {
        return $this->ChangedSinceDate;
    }
    /**
     * Set ChangedSinceDate value
     * @param string $changedSinceDate
     * @return \StructType\OrderRequest
     */
    public function setChangedSinceDate($changedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($changedSinceDate) && !is_string($changedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedSinceDate, true), gettype($changedSinceDate)), __LINE__);
        }
        $this->ChangedSinceDate = $changedSinceDate;
        return $this;
    }
    /**
     * Get ResponseDetails value
     * @return string
     */
    public function getResponseDetails()
    {
        return $this->ResponseDetails;
    }
    /**
     * Set ResponseDetails value
     * @uses \EnumType\OrderResponseDetails::valueIsValid()
     * @uses \EnumType\OrderResponseDetails::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $responseDetails
     * @return \StructType\OrderRequest
     */
    public function setResponseDetails($responseDetails = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderResponseDetails::valueIsValid($responseDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderResponseDetails', is_array($responseDetails) ? implode(', ', $responseDetails) : var_export($responseDetails, true), implode(', ', \EnumType\OrderResponseDetails::getValidValues())), __LINE__);
        }
        $this->ResponseDetails = $responseDetails;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\OrderRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\OrderRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\OrderRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\OrderRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
}
