<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * @subpackage Structs
 */
class Order extends BaseContract_FullIDSet
{
    /**
     * The OrderStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderStatus;
    /**
     * The DeliveryStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryStatus;
    /**
     * The LastChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastChange;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $DeliveryAddress;
    /**
     * The InvoiceAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $InvoiceAddress;
    /**
     * The OrderPositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderPosition
     */
    public $OrderPositions;
    /**
     * The AdditionalCosts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAdditionalCost
     */
    public $AdditionalCosts;
    /**
     * The OrderStockPositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderStockPosition
     */
    public $OrderStockPositions;
    /**
     * Constructor method for Order
     * @uses Order::setOrderStatus()
     * @uses Order::setDeliveryStatus()
     * @uses Order::setLastChange()
     * @uses Order::setBranchId()
     * @uses Order::setShopId()
     * @uses Order::setCustomerId()
     * @uses Order::setShopCustomerId()
     * @uses Order::setComment()
     * @uses Order::setDeliveryAddress()
     * @uses Order::setInvoiceAddress()
     * @uses Order::setOrderPositions()
     * @uses Order::setAdditionalCosts()
     * @uses Order::setOrderStockPositions()
     * @param string $orderStatus
     * @param string $deliveryStatus
     * @param string $lastChange
     * @param string $branchId
     * @param string $shopId
     * @param string $customerId
     * @param string $shopCustomerId
     * @param string $comment
     * @param \StructType\Address $deliveryAddress
     * @param \StructType\Address $invoiceAddress
     * @param \ArrayType\ArrayOfOrderPosition $orderPositions
     * @param \ArrayType\ArrayOfAdditionalCost $additionalCosts
     * @param \ArrayType\ArrayOfOrderStockPosition $orderStockPositions
     */
    public function __construct($orderStatus = null, $deliveryStatus = null, $lastChange = null, $branchId = null, $shopId = null, $customerId = null, $shopCustomerId = null, $comment = null, \StructType\Address $deliveryAddress = null, \StructType\Address $invoiceAddress = null, \ArrayType\ArrayOfOrderPosition $orderPositions = null, \ArrayType\ArrayOfAdditionalCost $additionalCosts = null, \ArrayType\ArrayOfOrderStockPosition $orderStockPositions = null)
    {
        $this
            ->setOrderStatus($orderStatus)
            ->setDeliveryStatus($deliveryStatus)
            ->setLastChange($lastChange)
            ->setBranchId($branchId)
            ->setShopId($shopId)
            ->setCustomerId($customerId)
            ->setShopCustomerId($shopCustomerId)
            ->setComment($comment)
            ->setDeliveryAddress($deliveryAddress)
            ->setInvoiceAddress($invoiceAddress)
            ->setOrderPositions($orderPositions)
            ->setAdditionalCosts($additionalCosts)
            ->setOrderStockPositions($orderStockPositions);
    }
    /**
     * Get OrderStatus value
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @uses \EnumType\OrderStatus::valueIsValid()
     * @uses \EnumType\OrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\Order
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderStatus::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderStatus', is_array($orderStatus) ? implode(', ', $orderStatus) : var_export($orderStatus, true), implode(', ', \EnumType\OrderStatus::getValidValues())), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get DeliveryStatus value
     * @return string
     */
    public function getDeliveryStatus()
    {
        return $this->DeliveryStatus;
    }
    /**
     * Set DeliveryStatus value
     * @uses \EnumType\DeliveryStatus::valueIsValid()
     * @uses \EnumType\DeliveryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryStatus
     * @return \StructType\Order
     */
    public function setDeliveryStatus($deliveryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryStatus::valueIsValid($deliveryStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveryStatus', is_array($deliveryStatus) ? implode(', ', $deliveryStatus) : var_export($deliveryStatus, true), implode(', ', \EnumType\DeliveryStatus::getValidValues())), __LINE__);
        }
        $this->DeliveryStatus = $deliveryStatus;
        return $this;
    }
    /**
     * Get LastChange value
     * @return string
     */
    public function getLastChange()
    {
        return $this->LastChange;
    }
    /**
     * Set LastChange value
     * @param string $lastChange
     * @return \StructType\Order
     */
    public function setLastChange($lastChange = null)
    {
        // validation for constraint: string
        if (!is_null($lastChange) && !is_string($lastChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChange, true), gettype($lastChange)), __LINE__);
        }
        $this->LastChange = $lastChange;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\Order
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\Order
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\Order
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\Order
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Order
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \StructType\Address|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \StructType\Address $deliveryAddress
     * @return \StructType\Order
     */
    public function setDeliveryAddress(\StructType\Address $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get InvoiceAddress value
     * @return \StructType\Address|null
     */
    public function getInvoiceAddress()
    {
        return $this->InvoiceAddress;
    }
    /**
     * Set InvoiceAddress value
     * @param \StructType\Address $invoiceAddress
     * @return \StructType\Order
     */
    public function setInvoiceAddress(\StructType\Address $invoiceAddress = null)
    {
        $this->InvoiceAddress = $invoiceAddress;
        return $this;
    }
    /**
     * Get OrderPositions value
     * @return \ArrayType\ArrayOfOrderPosition|null
     */
    public function getOrderPositions()
    {
        return $this->OrderPositions;
    }
    /**
     * Set OrderPositions value
     * @param \ArrayType\ArrayOfOrderPosition $orderPositions
     * @return \StructType\Order
     */
    public function setOrderPositions(\ArrayType\ArrayOfOrderPosition $orderPositions = null)
    {
        $this->OrderPositions = $orderPositions;
        return $this;
    }
    /**
     * Get AdditionalCosts value
     * @return \ArrayType\ArrayOfAdditionalCost|null
     */
    public function getAdditionalCosts()
    {
        return $this->AdditionalCosts;
    }
    /**
     * Set AdditionalCosts value
     * @param \ArrayType\ArrayOfAdditionalCost $additionalCosts
     * @return \StructType\Order
     */
    public function setAdditionalCosts(\ArrayType\ArrayOfAdditionalCost $additionalCosts = null)
    {
        $this->AdditionalCosts = $additionalCosts;
        return $this;
    }
    /**
     * Get OrderStockPositions value
     * @return \ArrayType\ArrayOfOrderStockPosition|null
     */
    public function getOrderStockPositions()
    {
        return $this->OrderStockPositions;
    }
    /**
     * Set OrderStockPositions value
     * @param \ArrayType\ArrayOfOrderStockPosition $orderStockPositions
     * @return \StructType\Order
     */
    public function setOrderStockPositions(\ArrayType\ArrayOfOrderStockPosition $orderStockPositions = null)
    {
        $this->OrderStockPositions = $orderStockPositions;
        return $this;
    }
}
