<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturerColourRequest StructType
 * @subpackage Structs
 */
class ManufacturerColourRequest extends BaseIDRequest
{
    /**
     * The ManufacturerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerID;
    /**
     * Constructor method for ManufacturerColourRequest
     * @uses ManufacturerColourRequest::setManufacturerID()
     * @param string $manufacturerID
     */
    public function __construct($manufacturerID = null)
    {
        $this
            ->setManufacturerID($manufacturerID);
    }
    /**
     * Get ManufacturerID value
     * @return string|null
     */
    public function getManufacturerID()
    {
        return $this->ManufacturerID;
    }
    /**
     * Set ManufacturerID value
     * @param string $manufacturerID
     * @return \StructType\ManufacturerColourRequest
     */
    public function setManufacturerID($manufacturerID = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerID) && !is_string($manufacturerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerID, true), gettype($manufacturerID)), __LINE__);
        }
        $this->ManufacturerID = $manufacturerID;
        return $this;
    }
}
