<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Language StructType
 * @subpackage Structs
 */
class Language extends BaseContract_Oid
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The LanguageISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageISO;
    /**
     * Constructor method for Language
     * @uses Language::setDescription()
     * @uses Language::setLanguageISO()
     * @param string $description
     * @param string $languageISO
     */
    public function __construct($description = null, $languageISO = null)
    {
        $this
            ->setDescription($description)
            ->setLanguageISO($languageISO);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Language
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get LanguageISO value
     * @return string|null
     */
    public function getLanguageISO()
    {
        return $this->LanguageISO;
    }
    /**
     * Set LanguageISO value
     * @param string $languageISO
     * @return \StructType\Language
     */
    public function setLanguageISO($languageISO = null)
    {
        // validation for constraint: string
        if (!is_null($languageISO) && !is_string($languageISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageISO, true), gettype($languageISO)), __LINE__);
        }
        $this->LanguageISO = $languageISO;
        return $this;
    }
}
