<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterBranchTransferHead StructType
 * @subpackage Structs
 */
class InterBranchTransferHead extends AbstractStructBase
{
    /**
     * The Oid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Oid;
    /**
     * The ChangedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedAt;
    /**
     * The CreatedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreatedAt;
    /**
     * The IsAdvicePossible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAdvicePossible;
    /**
     * The IsDone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDone;
    /**
     * The IsOpen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOpen;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrinted;
    /**
     * The IsReceiveAdviceRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReceiveAdviceRequired;
    /**
     * The IsReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReceived;
    /**
     * The IsReceivedWithDifference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReceivedWithDifference;
    /**
     * The IsSent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSent;
    /**
     * The BranchNoReceiving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchNoReceiving;
    /**
     * The BranchNoSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchNoSending;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInterBranchTransferDetail
     */
    public $Items;
    /**
     * Constructor method for InterBranchTransferHead
     * @uses InterBranchTransferHead::setOid()
     * @uses InterBranchTransferHead::setChangedAt()
     * @uses InterBranchTransferHead::setCreatedAt()
     * @uses InterBranchTransferHead::setIsAdvicePossible()
     * @uses InterBranchTransferHead::setIsDone()
     * @uses InterBranchTransferHead::setIsOpen()
     * @uses InterBranchTransferHead::setIsPrinted()
     * @uses InterBranchTransferHead::setIsReceiveAdviceRequired()
     * @uses InterBranchTransferHead::setIsReceived()
     * @uses InterBranchTransferHead::setIsReceivedWithDifference()
     * @uses InterBranchTransferHead::setIsSent()
     * @uses InterBranchTransferHead::setBranchNoReceiving()
     * @uses InterBranchTransferHead::setBranchNoSending()
     * @uses InterBranchTransferHead::setDescription()
     * @uses InterBranchTransferHead::setMemo()
     * @uses InterBranchTransferHead::setNumber()
     * @uses InterBranchTransferHead::setState()
     * @uses InterBranchTransferHead::setItems()
     * @param string $oid
     * @param string $changedAt
     * @param string $createdAt
     * @param bool $isAdvicePossible
     * @param bool $isDone
     * @param bool $isOpen
     * @param bool $isPrinted
     * @param bool $isReceiveAdviceRequired
     * @param bool $isReceived
     * @param bool $isReceivedWithDifference
     * @param bool $isSent
     * @param int $branchNoReceiving
     * @param int $branchNoSending
     * @param string $description
     * @param string $memo
     * @param string $number
     * @param string $state
     * @param \ArrayType\ArrayOfInterBranchTransferDetail $items
     */
    public function __construct($oid = null, $changedAt = null, $createdAt = null, $isAdvicePossible = null, $isDone = null, $isOpen = null, $isPrinted = null, $isReceiveAdviceRequired = null, $isReceived = null, $isReceivedWithDifference = null, $isSent = null, $branchNoReceiving = null, $branchNoSending = null, $description = null, $memo = null, $number = null, $state = null, \ArrayType\ArrayOfInterBranchTransferDetail $items = null)
    {
        $this
            ->setOid($oid)
            ->setChangedAt($changedAt)
            ->setCreatedAt($createdAt)
            ->setIsAdvicePossible($isAdvicePossible)
            ->setIsDone($isDone)
            ->setIsOpen($isOpen)
            ->setIsPrinted($isPrinted)
            ->setIsReceiveAdviceRequired($isReceiveAdviceRequired)
            ->setIsReceived($isReceived)
            ->setIsReceivedWithDifference($isReceivedWithDifference)
            ->setIsSent($isSent)
            ->setBranchNoReceiving($branchNoReceiving)
            ->setBranchNoSending($branchNoSending)
            ->setDescription($description)
            ->setMemo($memo)
            ->setNumber($number)
            ->setState($state)
            ->setItems($items);
    }
    /**
     * Get Oid value
     * @return string
     */
    public function getOid()
    {
        return $this->Oid;
    }
    /**
     * Set Oid value
     * @param string $oid
     * @return \StructType\InterBranchTransferHead
     */
    public function setOid($oid = null)
    {
        // validation for constraint: string
        if (!is_null($oid) && !is_string($oid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oid, true), gettype($oid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($oid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $oid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($oid, true)), __LINE__);
        }
        $this->Oid = $oid;
        return $this;
    }
    /**
     * Get ChangedAt value
     * @return string
     */
    public function getChangedAt()
    {
        return $this->ChangedAt;
    }
    /**
     * Set ChangedAt value
     * @param string $changedAt
     * @return \StructType\InterBranchTransferHead
     */
    public function setChangedAt($changedAt = null)
    {
        // validation for constraint: string
        if (!is_null($changedAt) && !is_string($changedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedAt, true), gettype($changedAt)), __LINE__);
        }
        $this->ChangedAt = $changedAt;
        return $this;
    }
    /**
     * Get CreatedAt value
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->CreatedAt;
    }
    /**
     * Set CreatedAt value
     * @param string $createdAt
     * @return \StructType\InterBranchTransferHead
     */
    public function setCreatedAt($createdAt = null)
    {
        // validation for constraint: string
        if (!is_null($createdAt) && !is_string($createdAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAt, true), gettype($createdAt)), __LINE__);
        }
        $this->CreatedAt = $createdAt;
        return $this;
    }
    /**
     * Get IsAdvicePossible value
     * @return bool
     */
    public function getIsAdvicePossible()
    {
        return $this->IsAdvicePossible;
    }
    /**
     * Set IsAdvicePossible value
     * @param bool $isAdvicePossible
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsAdvicePossible($isAdvicePossible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdvicePossible) && !is_bool($isAdvicePossible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAdvicePossible, true), gettype($isAdvicePossible)), __LINE__);
        }
        $this->IsAdvicePossible = $isAdvicePossible;
        return $this;
    }
    /**
     * Get IsDone value
     * @return bool
     */
    public function getIsDone()
    {
        return $this->IsDone;
    }
    /**
     * Set IsDone value
     * @param bool $isDone
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsDone($isDone = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDone) && !is_bool($isDone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDone, true), gettype($isDone)), __LINE__);
        }
        $this->IsDone = $isDone;
        return $this;
    }
    /**
     * Get IsOpen value
     * @return bool
     */
    public function getIsOpen()
    {
        return $this->IsOpen;
    }
    /**
     * Set IsOpen value
     * @param bool $isOpen
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsOpen($isOpen = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpen) && !is_bool($isOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOpen, true), gettype($isOpen)), __LINE__);
        }
        $this->IsOpen = $isOpen;
        return $this;
    }
    /**
     * Get IsPrinted value
     * @return bool
     */
    public function getIsPrinted()
    {
        return $this->IsPrinted;
    }
    /**
     * Set IsPrinted value
     * @param bool $isPrinted
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        $this->IsPrinted = $isPrinted;
        return $this;
    }
    /**
     * Get IsReceiveAdviceRequired value
     * @return bool
     */
    public function getIsReceiveAdviceRequired()
    {
        return $this->IsReceiveAdviceRequired;
    }
    /**
     * Set IsReceiveAdviceRequired value
     * @param bool $isReceiveAdviceRequired
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsReceiveAdviceRequired($isReceiveAdviceRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReceiveAdviceRequired) && !is_bool($isReceiveAdviceRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReceiveAdviceRequired, true), gettype($isReceiveAdviceRequired)), __LINE__);
        }
        $this->IsReceiveAdviceRequired = $isReceiveAdviceRequired;
        return $this;
    }
    /**
     * Get IsReceived value
     * @return bool
     */
    public function getIsReceived()
    {
        return $this->IsReceived;
    }
    /**
     * Set IsReceived value
     * @param bool $isReceived
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsReceived($isReceived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReceived) && !is_bool($isReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReceived, true), gettype($isReceived)), __LINE__);
        }
        $this->IsReceived = $isReceived;
        return $this;
    }
    /**
     * Get IsReceivedWithDifference value
     * @return bool
     */
    public function getIsReceivedWithDifference()
    {
        return $this->IsReceivedWithDifference;
    }
    /**
     * Set IsReceivedWithDifference value
     * @param bool $isReceivedWithDifference
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsReceivedWithDifference($isReceivedWithDifference = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReceivedWithDifference) && !is_bool($isReceivedWithDifference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReceivedWithDifference, true), gettype($isReceivedWithDifference)), __LINE__);
        }
        $this->IsReceivedWithDifference = $isReceivedWithDifference;
        return $this;
    }
    /**
     * Get IsSent value
     * @return bool
     */
    public function getIsSent()
    {
        return $this->IsSent;
    }
    /**
     * Set IsSent value
     * @param bool $isSent
     * @return \StructType\InterBranchTransferHead
     */
    public function setIsSent($isSent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSent) && !is_bool($isSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSent, true), gettype($isSent)), __LINE__);
        }
        $this->IsSent = $isSent;
        return $this;
    }
    /**
     * Get BranchNoReceiving value
     * @return int
     */
    public function getBranchNoReceiving()
    {
        return $this->BranchNoReceiving;
    }
    /**
     * Set BranchNoReceiving value
     * @param int $branchNoReceiving
     * @return \StructType\InterBranchTransferHead
     */
    public function setBranchNoReceiving($branchNoReceiving = null)
    {
        // validation for constraint: int
        if (!is_null($branchNoReceiving) && !(is_int($branchNoReceiving) || ctype_digit($branchNoReceiving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchNoReceiving, true), gettype($branchNoReceiving)), __LINE__);
        }
        $this->BranchNoReceiving = $branchNoReceiving;
        return $this;
    }
    /**
     * Get BranchNoSending value
     * @return int
     */
    public function getBranchNoSending()
    {
        return $this->BranchNoSending;
    }
    /**
     * Set BranchNoSending value
     * @param int $branchNoSending
     * @return \StructType\InterBranchTransferHead
     */
    public function setBranchNoSending($branchNoSending = null)
    {
        // validation for constraint: int
        if (!is_null($branchNoSending) && !(is_int($branchNoSending) || ctype_digit($branchNoSending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchNoSending, true), gettype($branchNoSending)), __LINE__);
        }
        $this->BranchNoSending = $branchNoSending;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\InterBranchTransferHead
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\InterBranchTransferHead
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\InterBranchTransferHead
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\InterBranchTransferHead
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfInterBranchTransferDetail|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfInterBranchTransferDetail $items
     * @return \StructType\InterBranchTransferHead
     */
    public function setItems(\ArrayType\ArrayOfInterBranchTransferDetail $items = null)
    {
        $this->Items = $items;
        return $this;
    }
}
