<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IbtCreatorRequest StructType
 * @subpackage Structs
 */
class IbtCreatorRequest extends AbstractStructBase
{
    /**
     * The IbtCreationMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IbtCreationMode;
    /**
     * The SenderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SenderNo;
    /**
     * The ReceiverNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiverNo;
    /**
     * The DiscardZeroQuantityDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DiscardZeroQuantityDetails;
    /**
     * The IbtAdviceData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IbtAdviceData
     */
    public $IbtAdviceData;
    /**
     * The PostCreationAction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PostCreationAction
     */
    public $PostCreationAction;
    /**
     * The NewIbtNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewIbtNo;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The PositionCreators
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIbtDetailRequest
     */
    public $PositionCreators;
    /**
     * The FLTPAToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FLTPAToken;
    /**
     * Constructor method for IbtCreatorRequest
     * @uses IbtCreatorRequest::setIbtCreationMode()
     * @uses IbtCreatorRequest::setSenderNo()
     * @uses IbtCreatorRequest::setReceiverNo()
     * @uses IbtCreatorRequest::setDiscardZeroQuantityDetails()
     * @uses IbtCreatorRequest::setIbtAdviceData()
     * @uses IbtCreatorRequest::setPostCreationAction()
     * @uses IbtCreatorRequest::setNewIbtNo()
     * @uses IbtCreatorRequest::setMemo()
     * @uses IbtCreatorRequest::setPositionCreators()
     * @uses IbtCreatorRequest::setFLTPAToken()
     * @param string $ibtCreationMode
     * @param int $senderNo
     * @param int $receiverNo
     * @param bool $discardZeroQuantityDetails
     * @param \StructType\IbtAdviceData $ibtAdviceData
     * @param \StructType\PostCreationAction $postCreationAction
     * @param string $newIbtNo
     * @param string $memo
     * @param \ArrayType\ArrayOfIbtDetailRequest $positionCreators
     * @param string $fLTPAToken
     */
    public function __construct($ibtCreationMode = null, $senderNo = null, $receiverNo = null, $discardZeroQuantityDetails = null, \StructType\IbtAdviceData $ibtAdviceData = null, \StructType\PostCreationAction $postCreationAction = null, $newIbtNo = null, $memo = null, \ArrayType\ArrayOfIbtDetailRequest $positionCreators = null, $fLTPAToken = null)
    {
        $this
            ->setIbtCreationMode($ibtCreationMode)
            ->setSenderNo($senderNo)
            ->setReceiverNo($receiverNo)
            ->setDiscardZeroQuantityDetails($discardZeroQuantityDetails)
            ->setIbtAdviceData($ibtAdviceData)
            ->setPostCreationAction($postCreationAction)
            ->setNewIbtNo($newIbtNo)
            ->setMemo($memo)
            ->setPositionCreators($positionCreators)
            ->setFLTPAToken($fLTPAToken);
    }
    /**
     * Get IbtCreationMode value
     * @return string
     */
    public function getIbtCreationMode()
    {
        return $this->IbtCreationMode;
    }
    /**
     * Set IbtCreationMode value
     * @uses \EnumType\IbtCreationMode::valueIsValid()
     * @uses \EnumType\IbtCreationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ibtCreationMode
     * @return \StructType\IbtCreatorRequest
     */
    public function setIbtCreationMode($ibtCreationMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IbtCreationMode::valueIsValid($ibtCreationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IbtCreationMode', is_array($ibtCreationMode) ? implode(', ', $ibtCreationMode) : var_export($ibtCreationMode, true), implode(', ', \EnumType\IbtCreationMode::getValidValues())), __LINE__);
        }
        $this->IbtCreationMode = $ibtCreationMode;
        return $this;
    }
    /**
     * Get SenderNo value
     * @return int
     */
    public function getSenderNo()
    {
        return $this->SenderNo;
    }
    /**
     * Set SenderNo value
     * @param int $senderNo
     * @return \StructType\IbtCreatorRequest
     */
    public function setSenderNo($senderNo = null)
    {
        // validation for constraint: int
        if (!is_null($senderNo) && !(is_int($senderNo) || ctype_digit($senderNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($senderNo, true), gettype($senderNo)), __LINE__);
        }
        $this->SenderNo = $senderNo;
        return $this;
    }
    /**
     * Get ReceiverNo value
     * @return int
     */
    public function getReceiverNo()
    {
        return $this->ReceiverNo;
    }
    /**
     * Set ReceiverNo value
     * @param int $receiverNo
     * @return \StructType\IbtCreatorRequest
     */
    public function setReceiverNo($receiverNo = null)
    {
        // validation for constraint: int
        if (!is_null($receiverNo) && !(is_int($receiverNo) || ctype_digit($receiverNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiverNo, true), gettype($receiverNo)), __LINE__);
        }
        $this->ReceiverNo = $receiverNo;
        return $this;
    }
    /**
     * Get DiscardZeroQuantityDetails value
     * @return bool
     */
    public function getDiscardZeroQuantityDetails()
    {
        return $this->DiscardZeroQuantityDetails;
    }
    /**
     * Set DiscardZeroQuantityDetails value
     * @param bool $discardZeroQuantityDetails
     * @return \StructType\IbtCreatorRequest
     */
    public function setDiscardZeroQuantityDetails($discardZeroQuantityDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($discardZeroQuantityDetails) && !is_bool($discardZeroQuantityDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($discardZeroQuantityDetails, true), gettype($discardZeroQuantityDetails)), __LINE__);
        }
        $this->DiscardZeroQuantityDetails = $discardZeroQuantityDetails;
        return $this;
    }
    /**
     * Get IbtAdviceData value
     * @return \StructType\IbtAdviceData|null
     */
    public function getIbtAdviceData()
    {
        return $this->IbtAdviceData;
    }
    /**
     * Set IbtAdviceData value
     * @param \StructType\IbtAdviceData $ibtAdviceData
     * @return \StructType\IbtCreatorRequest
     */
    public function setIbtAdviceData(\StructType\IbtAdviceData $ibtAdviceData = null)
    {
        $this->IbtAdviceData = $ibtAdviceData;
        return $this;
    }
    /**
     * Get PostCreationAction value
     * @return \StructType\PostCreationAction|null
     */
    public function getPostCreationAction()
    {
        return $this->PostCreationAction;
    }
    /**
     * Set PostCreationAction value
     * @param \StructType\PostCreationAction $postCreationAction
     * @return \StructType\IbtCreatorRequest
     */
    public function setPostCreationAction(\StructType\PostCreationAction $postCreationAction = null)
    {
        $this->PostCreationAction = $postCreationAction;
        return $this;
    }
    /**
     * Get NewIbtNo value
     * @return string|null
     */
    public function getNewIbtNo()
    {
        return $this->NewIbtNo;
    }
    /**
     * Set NewIbtNo value
     * @param string $newIbtNo
     * @return \StructType\IbtCreatorRequest
     */
    public function setNewIbtNo($newIbtNo = null)
    {
        // validation for constraint: string
        if (!is_null($newIbtNo) && !is_string($newIbtNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newIbtNo, true), gettype($newIbtNo)), __LINE__);
        }
        $this->NewIbtNo = $newIbtNo;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\IbtCreatorRequest
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get PositionCreators value
     * @return \ArrayType\ArrayOfIbtDetailRequest|null
     */
    public function getPositionCreators()
    {
        return $this->PositionCreators;
    }
    /**
     * Set PositionCreators value
     * @param \ArrayType\ArrayOfIbtDetailRequest $positionCreators
     * @return \StructType\IbtCreatorRequest
     */
    public function setPositionCreators(\ArrayType\ArrayOfIbtDetailRequest $positionCreators = null)
    {
        $this->PositionCreators = $positionCreators;
        return $this;
    }
    /**
     * Get FLTPAToken value
     * @return string|null
     */
    public function getFLTPAToken()
    {
        return $this->FLTPAToken;
    }
    /**
     * Set FLTPAToken value
     * @param string $fLTPAToken
     * @return \StructType\IbtCreatorRequest
     */
    public function setFLTPAToken($fLTPAToken = null)
    {
        // validation for constraint: string
        if (!is_null($fLTPAToken) && !is_string($fLTPAToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fLTPAToken, true), gettype($fLTPAToken)), __LINE__);
        }
        $this->FLTPAToken = $fLTPAToken;
        return $this;
    }
}
