<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsInAdvice StructType
 * @subpackage Structs
 */
class GoodsInAdvice extends AbstractStructBase
{
    /**
     * The DeliveryNoteTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryNoteTimestamp;
    /**
     * The CheckedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CheckedQuantity;
    /**
     * The ExpectedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExpectedQuantity;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The DeliveryNoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNoteId;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The Originator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Originator;
    /**
     * The Recipient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recipient;
    /**
     * The AdviceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGoodsInAdviceDetail
     */
    public $AdviceDetails;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for GoodsInAdvice
     * @uses GoodsInAdvice::setDeliveryNoteTimestamp()
     * @uses GoodsInAdvice::setCheckedQuantity()
     * @uses GoodsInAdvice::setExpectedQuantity()
     * @uses GoodsInAdvice::setID()
     * @uses GoodsInAdvice::setDeliveryNoteId()
     * @uses GoodsInAdvice::setDocumentId()
     * @uses GoodsInAdvice::setOriginator()
     * @uses GoodsInAdvice::setRecipient()
     * @uses GoodsInAdvice::setAdviceDetails()
     * @uses GoodsInAdvice::setDescription()
     * @uses GoodsInAdvice::setStatus()
     * @param string $deliveryNoteTimestamp
     * @param float $checkedQuantity
     * @param float $expectedQuantity
     * @param string $iD
     * @param string $deliveryNoteId
     * @param string $documentId
     * @param string $originator
     * @param string $recipient
     * @param \ArrayType\ArrayOfGoodsInAdviceDetail $adviceDetails
     * @param string $description
     * @param string $status
     */
    public function __construct($deliveryNoteTimestamp = null, $checkedQuantity = null, $expectedQuantity = null, $iD = null, $deliveryNoteId = null, $documentId = null, $originator = null, $recipient = null, \ArrayType\ArrayOfGoodsInAdviceDetail $adviceDetails = null, $description = null, $status = null)
    {
        $this
            ->setDeliveryNoteTimestamp($deliveryNoteTimestamp)
            ->setCheckedQuantity($checkedQuantity)
            ->setExpectedQuantity($expectedQuantity)
            ->setID($iD)
            ->setDeliveryNoteId($deliveryNoteId)
            ->setDocumentId($documentId)
            ->setOriginator($originator)
            ->setRecipient($recipient)
            ->setAdviceDetails($adviceDetails)
            ->setDescription($description)
            ->setStatus($status);
    }
    /**
     * Get DeliveryNoteTimestamp value
     * @return string
     */
    public function getDeliveryNoteTimestamp()
    {
        return $this->DeliveryNoteTimestamp;
    }
    /**
     * Set DeliveryNoteTimestamp value
     * @param string $deliveryNoteTimestamp
     * @return \StructType\GoodsInAdvice
     */
    public function setDeliveryNoteTimestamp($deliveryNoteTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteTimestamp) && !is_string($deliveryNoteTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteTimestamp, true), gettype($deliveryNoteTimestamp)), __LINE__);
        }
        $this->DeliveryNoteTimestamp = $deliveryNoteTimestamp;
        return $this;
    }
    /**
     * Get CheckedQuantity value
     * @return float
     */
    public function getCheckedQuantity()
    {
        return $this->CheckedQuantity;
    }
    /**
     * Set CheckedQuantity value
     * @param float $checkedQuantity
     * @return \StructType\GoodsInAdvice
     */
    public function setCheckedQuantity($checkedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($checkedQuantity) && !(is_float($checkedQuantity) || is_numeric($checkedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($checkedQuantity, true), gettype($checkedQuantity)), __LINE__);
        }
        $this->CheckedQuantity = $checkedQuantity;
        return $this;
    }
    /**
     * Get ExpectedQuantity value
     * @return float
     */
    public function getExpectedQuantity()
    {
        return $this->ExpectedQuantity;
    }
    /**
     * Set ExpectedQuantity value
     * @param float $expectedQuantity
     * @return \StructType\GoodsInAdvice
     */
    public function setExpectedQuantity($expectedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($expectedQuantity) && !(is_float($expectedQuantity) || is_numeric($expectedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedQuantity, true), gettype($expectedQuantity)), __LINE__);
        }
        $this->ExpectedQuantity = $expectedQuantity;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\GoodsInAdvice
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get DeliveryNoteId value
     * @return string|null
     */
    public function getDeliveryNoteId()
    {
        return $this->DeliveryNoteId;
    }
    /**
     * Set DeliveryNoteId value
     * @param string $deliveryNoteId
     * @return \StructType\GoodsInAdvice
     */
    public function setDeliveryNoteId($deliveryNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteId) && !is_string($deliveryNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteId, true), gettype($deliveryNoteId)), __LINE__);
        }
        $this->DeliveryNoteId = $deliveryNoteId;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \StructType\GoodsInAdvice
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get Originator value
     * @return string|null
     */
    public function getOriginator()
    {
        return $this->Originator;
    }
    /**
     * Set Originator value
     * @param string $originator
     * @return \StructType\GoodsInAdvice
     */
    public function setOriginator($originator = null)
    {
        // validation for constraint: string
        if (!is_null($originator) && !is_string($originator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originator, true), gettype($originator)), __LINE__);
        }
        $this->Originator = $originator;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param string $recipient
     * @return \StructType\GoodsInAdvice
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipient, true), gettype($recipient)), __LINE__);
        }
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get AdviceDetails value
     * @return \ArrayType\ArrayOfGoodsInAdviceDetail|null
     */
    public function getAdviceDetails()
    {
        return $this->AdviceDetails;
    }
    /**
     * Set AdviceDetails value
     * @param \ArrayType\ArrayOfGoodsInAdviceDetail $adviceDetails
     * @return \StructType\GoodsInAdvice
     */
    public function setAdviceDetails(\ArrayType\ArrayOfGoodsInAdviceDetail $adviceDetails = null)
    {
        $this->AdviceDetails = $adviceDetails;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\GoodsInAdvice
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\GoodsInAdvice
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
