<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EanPriceBase StructType
 * @subpackage Structs
 */
class EanPriceBase extends AbstractStructBase
{
    /**
     * The SuggestedPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SuggestedPrice;
    /**
     * The UnrealisticPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnrealisticPrice;
    /**
     * The IsNOS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNOS;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The Oid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Oid;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The ColorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ColorID;
    /**
     * The ColorOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ColorOid;
    /**
     * The SystemColor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemColor;
    /**
     * The SystemColorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemColorId;
    /**
     * The SystemColorOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemColorOid;
    /**
     * The EanCharacteristics
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCharacteristic
     */
    public $EanCharacteristics;
    /**
     * Constructor method for EanPriceBase
     * @uses EanPriceBase::setSuggestedPrice()
     * @uses EanPriceBase::setUnrealisticPrice()
     * @uses EanPriceBase::setIsNOS()
     * @uses EanPriceBase::setEAN()
     * @uses EanPriceBase::setOid()
     * @uses EanPriceBase::setSize()
     * @uses EanPriceBase::setColor()
     * @uses EanPriceBase::setColorID()
     * @uses EanPriceBase::setColorOid()
     * @uses EanPriceBase::setSystemColor()
     * @uses EanPriceBase::setSystemColorId()
     * @uses EanPriceBase::setSystemColorOid()
     * @uses EanPriceBase::setEanCharacteristics()
     * @param float $suggestedPrice
     * @param float $unrealisticPrice
     * @param bool $isNOS
     * @param string $eAN
     * @param string $oid
     * @param string $size
     * @param string $color
     * @param string $colorID
     * @param string $colorOid
     * @param string $systemColor
     * @param string $systemColorId
     * @param string $systemColorOid
     * @param \ArrayType\ArrayOfCharacteristic $eanCharacteristics
     */
    public function __construct($suggestedPrice = null, $unrealisticPrice = null, $isNOS = null, $eAN = null, $oid = null, $size = null, $color = null, $colorID = null, $colorOid = null, $systemColor = null, $systemColorId = null, $systemColorOid = null, \ArrayType\ArrayOfCharacteristic $eanCharacteristics = null)
    {
        $this
            ->setSuggestedPrice($suggestedPrice)
            ->setUnrealisticPrice($unrealisticPrice)
            ->setIsNOS($isNOS)
            ->setEAN($eAN)
            ->setOid($oid)
            ->setSize($size)
            ->setColor($color)
            ->setColorID($colorID)
            ->setColorOid($colorOid)
            ->setSystemColor($systemColor)
            ->setSystemColorId($systemColorId)
            ->setSystemColorOid($systemColorOid)
            ->setEanCharacteristics($eanCharacteristics);
    }
    /**
     * Get SuggestedPrice value
     * @return float
     */
    public function getSuggestedPrice()
    {
        return $this->SuggestedPrice;
    }
    /**
     * Set SuggestedPrice value
     * @param float $suggestedPrice
     * @return \StructType\EanPriceBase
     */
    public function setSuggestedPrice($suggestedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($suggestedPrice) && !(is_float($suggestedPrice) || is_numeric($suggestedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($suggestedPrice, true), gettype($suggestedPrice)), __LINE__);
        }
        $this->SuggestedPrice = $suggestedPrice;
        return $this;
    }
    /**
     * Get UnrealisticPrice value
     * @return float
     */
    public function getUnrealisticPrice()
    {
        return $this->UnrealisticPrice;
    }
    /**
     * Set UnrealisticPrice value
     * @param float $unrealisticPrice
     * @return \StructType\EanPriceBase
     */
    public function setUnrealisticPrice($unrealisticPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unrealisticPrice) && !(is_float($unrealisticPrice) || is_numeric($unrealisticPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unrealisticPrice, true), gettype($unrealisticPrice)), __LINE__);
        }
        $this->UnrealisticPrice = $unrealisticPrice;
        return $this;
    }
    /**
     * Get IsNOS value
     * @return bool
     */
    public function getIsNOS()
    {
        return $this->IsNOS;
    }
    /**
     * Set IsNOS value
     * @param bool $isNOS
     * @return \StructType\EanPriceBase
     */
    public function setIsNOS($isNOS = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNOS) && !is_bool($isNOS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNOS, true), gettype($isNOS)), __LINE__);
        }
        $this->IsNOS = $isNOS;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\EanPriceBase
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get Oid value
     * @return string|null
     */
    public function getOid()
    {
        return $this->Oid;
    }
    /**
     * Set Oid value
     * @param string $oid
     * @return \StructType\EanPriceBase
     */
    public function setOid($oid = null)
    {
        // validation for constraint: string
        if (!is_null($oid) && !is_string($oid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oid, true), gettype($oid)), __LINE__);
        }
        $this->Oid = $oid;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\EanPriceBase
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\EanPriceBase
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get ColorID value
     * @return string|null
     */
    public function getColorID()
    {
        return $this->ColorID;
    }
    /**
     * Set ColorID value
     * @param string $colorID
     * @return \StructType\EanPriceBase
     */
    public function setColorID($colorID = null)
    {
        // validation for constraint: string
        if (!is_null($colorID) && !is_string($colorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorID, true), gettype($colorID)), __LINE__);
        }
        $this->ColorID = $colorID;
        return $this;
    }
    /**
     * Get ColorOid value
     * @return string|null
     */
    public function getColorOid()
    {
        return $this->ColorOid;
    }
    /**
     * Set ColorOid value
     * @param string $colorOid
     * @return \StructType\EanPriceBase
     */
    public function setColorOid($colorOid = null)
    {
        // validation for constraint: string
        if (!is_null($colorOid) && !is_string($colorOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorOid, true), gettype($colorOid)), __LINE__);
        }
        $this->ColorOid = $colorOid;
        return $this;
    }
    /**
     * Get SystemColor value
     * @return string|null
     */
    public function getSystemColor()
    {
        return $this->SystemColor;
    }
    /**
     * Set SystemColor value
     * @param string $systemColor
     * @return \StructType\EanPriceBase
     */
    public function setSystemColor($systemColor = null)
    {
        // validation for constraint: string
        if (!is_null($systemColor) && !is_string($systemColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemColor, true), gettype($systemColor)), __LINE__);
        }
        $this->SystemColor = $systemColor;
        return $this;
    }
    /**
     * Get SystemColorId value
     * @return string|null
     */
    public function getSystemColorId()
    {
        return $this->SystemColorId;
    }
    /**
     * Set SystemColorId value
     * @param string $systemColorId
     * @return \StructType\EanPriceBase
     */
    public function setSystemColorId($systemColorId = null)
    {
        // validation for constraint: string
        if (!is_null($systemColorId) && !is_string($systemColorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemColorId, true), gettype($systemColorId)), __LINE__);
        }
        $this->SystemColorId = $systemColorId;
        return $this;
    }
    /**
     * Get SystemColorOid value
     * @return string|null
     */
    public function getSystemColorOid()
    {
        return $this->SystemColorOid;
    }
    /**
     * Set SystemColorOid value
     * @param string $systemColorOid
     * @return \StructType\EanPriceBase
     */
    public function setSystemColorOid($systemColorOid = null)
    {
        // validation for constraint: string
        if (!is_null($systemColorOid) && !is_string($systemColorOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemColorOid, true), gettype($systemColorOid)), __LINE__);
        }
        $this->SystemColorOid = $systemColorOid;
        return $this;
    }
    /**
     * Get EanCharacteristics value
     * @return \ArrayType\ArrayOfCharacteristic|null
     */
    public function getEanCharacteristics()
    {
        return $this->EanCharacteristics;
    }
    /**
     * Set EanCharacteristics value
     * @param \ArrayType\ArrayOfCharacteristic $eanCharacteristics
     * @return \StructType\EanPriceBase
     */
    public function setEanCharacteristics(\ArrayType\ArrayOfCharacteristic $eanCharacteristics = null)
    {
        $this->EanCharacteristics = $eanCharacteristics;
        return $this;
    }
}
