<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryNoteRequest StructType
 * @subpackage Structs
 */
class DeliveryNoteRequest extends BaseIterationRequest
{
    /**
     * The ChangedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedSinceDate;
    /**
     * The DeliveryNoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNoteId;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * Constructor method for DeliveryNoteRequest
     * @uses DeliveryNoteRequest::setChangedSinceDate()
     * @uses DeliveryNoteRequest::setDeliveryNoteId()
     * @uses DeliveryNoteRequest::setOrderId()
     * @uses DeliveryNoteRequest::setBranchId()
     * @uses DeliveryNoteRequest::setShopId()
     * @uses DeliveryNoteRequest::setShopCustomerId()
     * @uses DeliveryNoteRequest::setCustomerId()
     * @param string $changedSinceDate
     * @param string $deliveryNoteId
     * @param string $orderId
     * @param string $branchId
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     */
    public function __construct($changedSinceDate = null, $deliveryNoteId = null, $orderId = null, $branchId = null, $shopId = null, $shopCustomerId = null, $customerId = null)
    {
        $this
            ->setChangedSinceDate($changedSinceDate)
            ->setDeliveryNoteId($deliveryNoteId)
            ->setOrderId($orderId)
            ->setBranchId($branchId)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId);
    }
    /**
     * Get ChangedSinceDate value
     * @return string
     */
    public function getChangedSinceDate()
    {
        return $this->ChangedSinceDate;
    }
    /**
     * Set ChangedSinceDate value
     * @param string $changedSinceDate
     * @return \StructType\DeliveryNoteRequest
     */
    public function setChangedSinceDate($changedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($changedSinceDate) && !is_string($changedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedSinceDate, true), gettype($changedSinceDate)), __LINE__);
        }
        $this->ChangedSinceDate = $changedSinceDate;
        return $this;
    }
    /**
     * Get DeliveryNoteId value
     * @return string|null
     */
    public function getDeliveryNoteId()
    {
        return $this->DeliveryNoteId;
    }
    /**
     * Set DeliveryNoteId value
     * @param string $deliveryNoteId
     * @return \StructType\DeliveryNoteRequest
     */
    public function setDeliveryNoteId($deliveryNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteId) && !is_string($deliveryNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteId, true), gettype($deliveryNoteId)), __LINE__);
        }
        $this->DeliveryNoteId = $deliveryNoteId;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\DeliveryNoteRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\DeliveryNoteRequest
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\DeliveryNoteRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\DeliveryNoteRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\DeliveryNoteRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
}
