<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletedObjectReference StructType
 * @subpackage Structs
 */
class DeletedObjectReference extends BaseContract_FullIDSet
{
    /**
     * The DeleteDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeleteDate;
    /**
     * The BusinessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessKey;
    /**
     * The ObjectType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectType;
    /**
     * The DeleteType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeleteType;
    /**
     * The ExternalRecordId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalRecordId;
    /**
     * The NewId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewId;
    /**
     * The OldId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OldId;
    /**
     * Constructor method for DeletedObjectReference
     * @uses DeletedObjectReference::setDeleteDate()
     * @uses DeletedObjectReference::setBusinessKey()
     * @uses DeletedObjectReference::setObjectType()
     * @uses DeletedObjectReference::setDeleteType()
     * @uses DeletedObjectReference::setExternalRecordId()
     * @uses DeletedObjectReference::setNewId()
     * @uses DeletedObjectReference::setOldId()
     * @param string $deleteDate
     * @param string $businessKey
     * @param string $objectType
     * @param string $deleteType
     * @param string $externalRecordId
     * @param string $newId
     * @param string $oldId
     */
    public function __construct($deleteDate = null, $businessKey = null, $objectType = null, $deleteType = null, $externalRecordId = null, $newId = null, $oldId = null)
    {
        $this
            ->setDeleteDate($deleteDate)
            ->setBusinessKey($businessKey)
            ->setObjectType($objectType)
            ->setDeleteType($deleteType)
            ->setExternalRecordId($externalRecordId)
            ->setNewId($newId)
            ->setOldId($oldId);
    }
    /**
     * Get DeleteDate value
     * @return string
     */
    public function getDeleteDate()
    {
        return $this->DeleteDate;
    }
    /**
     * Set DeleteDate value
     * @param string $deleteDate
     * @return \StructType\DeletedObjectReference
     */
    public function setDeleteDate($deleteDate = null)
    {
        // validation for constraint: string
        if (!is_null($deleteDate) && !is_string($deleteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deleteDate, true), gettype($deleteDate)), __LINE__);
        }
        $this->DeleteDate = $deleteDate;
        return $this;
    }
    /**
     * Get BusinessKey value
     * @return string|null
     */
    public function getBusinessKey()
    {
        return $this->BusinessKey;
    }
    /**
     * Set BusinessKey value
     * @param string $businessKey
     * @return \StructType\DeletedObjectReference
     */
    public function setBusinessKey($businessKey = null)
    {
        // validation for constraint: string
        if (!is_null($businessKey) && !is_string($businessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessKey, true), gettype($businessKey)), __LINE__);
        }
        $this->BusinessKey = $businessKey;
        return $this;
    }
    /**
     * Get ObjectType value
     * @return string|null
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \StructType\DeletedObjectReference
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectType, true), gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Get DeleteType value
     * @return string|null
     */
    public function getDeleteType()
    {
        return $this->DeleteType;
    }
    /**
     * Set DeleteType value
     * @param string $deleteType
     * @return \StructType\DeletedObjectReference
     */
    public function setDeleteType($deleteType = null)
    {
        // validation for constraint: string
        if (!is_null($deleteType) && !is_string($deleteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deleteType, true), gettype($deleteType)), __LINE__);
        }
        $this->DeleteType = $deleteType;
        return $this;
    }
    /**
     * Get ExternalRecordId value
     * @return string|null
     */
    public function getExternalRecordId()
    {
        return $this->ExternalRecordId;
    }
    /**
     * Set ExternalRecordId value
     * @param string $externalRecordId
     * @return \StructType\DeletedObjectReference
     */
    public function setExternalRecordId($externalRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($externalRecordId) && !is_string($externalRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalRecordId, true), gettype($externalRecordId)), __LINE__);
        }
        $this->ExternalRecordId = $externalRecordId;
        return $this;
    }
    /**
     * Get NewId value
     * @return string|null
     */
    public function getNewId()
    {
        return $this->NewId;
    }
    /**
     * Set NewId value
     * @param string $newId
     * @return \StructType\DeletedObjectReference
     */
    public function setNewId($newId = null)
    {
        // validation for constraint: string
        if (!is_null($newId) && !is_string($newId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newId, true), gettype($newId)), __LINE__);
        }
        $this->NewId = $newId;
        return $this;
    }
    /**
     * Get OldId value
     * @return string|null
     */
    public function getOldId()
    {
        return $this->OldId;
    }
    /**
     * Set OldId value
     * @param string $oldId
     * @return \StructType\DeletedObjectReference
     */
    public function setOldId($oldId = null)
    {
        // validation for constraint: string
        if (!is_null($oldId) && !is_string($oldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldId, true), gettype($oldId)), __LINE__);
        }
        $this->OldId = $oldId;
        return $this;
    }
}
