<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerRequest StructType
 * @subpackage Structs
 */
class CustomerRequest extends BaseIterationRequest
{
    /**
     * The FilterLockedCustomers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FilterLockedCustomers;
    /**
     * The ChangedSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangedSinceDate;
    /**
     * The WithCharacteristics
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $WithCharacteristics;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * Constructor method for CustomerRequest
     * @uses CustomerRequest::setFilterLockedCustomers()
     * @uses CustomerRequest::setChangedSinceDate()
     * @uses CustomerRequest::setWithCharacteristics()
     * @uses CustomerRequest::setShopId()
     * @uses CustomerRequest::setShopCustomerId()
     * @uses CustomerRequest::setCustomerId()
     * @param bool $filterLockedCustomers
     * @param string $changedSinceDate
     * @param bool $withCharacteristics
     * @param string $shopId
     * @param string $shopCustomerId
     * @param string $customerId
     */
    public function __construct($filterLockedCustomers = null, $changedSinceDate = null, $withCharacteristics = null, $shopId = null, $shopCustomerId = null, $customerId = null)
    {
        $this
            ->setFilterLockedCustomers($filterLockedCustomers)
            ->setChangedSinceDate($changedSinceDate)
            ->setWithCharacteristics($withCharacteristics)
            ->setShopId($shopId)
            ->setShopCustomerId($shopCustomerId)
            ->setCustomerId($customerId);
    }
    /**
     * Get FilterLockedCustomers value
     * @return bool
     */
    public function getFilterLockedCustomers()
    {
        return $this->FilterLockedCustomers;
    }
    /**
     * Set FilterLockedCustomers value
     * @param bool $filterLockedCustomers
     * @return \StructType\CustomerRequest
     */
    public function setFilterLockedCustomers($filterLockedCustomers = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterLockedCustomers) && !is_bool($filterLockedCustomers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterLockedCustomers, true), gettype($filterLockedCustomers)), __LINE__);
        }
        $this->FilterLockedCustomers = $filterLockedCustomers;
        return $this;
    }
    /**
     * Get ChangedSinceDate value
     * @return string
     */
    public function getChangedSinceDate()
    {
        return $this->ChangedSinceDate;
    }
    /**
     * Set ChangedSinceDate value
     * @param string $changedSinceDate
     * @return \StructType\CustomerRequest
     */
    public function setChangedSinceDate($changedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($changedSinceDate) && !is_string($changedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changedSinceDate, true), gettype($changedSinceDate)), __LINE__);
        }
        $this->ChangedSinceDate = $changedSinceDate;
        return $this;
    }
    /**
     * Get WithCharacteristics value
     * @return bool
     */
    public function getWithCharacteristics()
    {
        return $this->WithCharacteristics;
    }
    /**
     * Set WithCharacteristics value
     * @param bool $withCharacteristics
     * @return \StructType\CustomerRequest
     */
    public function setWithCharacteristics($withCharacteristics = null)
    {
        // validation for constraint: boolean
        if (!is_null($withCharacteristics) && !is_bool($withCharacteristics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withCharacteristics, true), gettype($withCharacteristics)), __LINE__);
        }
        $this->WithCharacteristics = $withCharacteristics;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\CustomerRequest
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\CustomerRequest
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\CustomerRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
}
