<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPurchaseHistory StructType
 * @subpackage Structs
 */
class CustomerPurchaseHistory extends AbstractStructBase
{
    /**
     * The TransactionTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionTimestamp;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The HistoryReceiptType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HistoryReceiptType;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LineType;
    /**
     * The ReceiptNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptNo;
    /**
     * The PositionNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PositionNo;
    /**
     * The ZNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ZNumber;
    /**
     * The PriceAlteration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceAlteration;
    /**
     * The TotalDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDiscount;
    /**
     * The BonusDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonusDiscount;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The ReceiptText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptText;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchId;
    /**
     * The ProductGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductGroupId;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * The SerialNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNo;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The SalesPersonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesPersonId;
    /**
     * The CashId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CashId;
    /**
     * The ArticleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleId;
    /**
     * The Discounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDiscount
     */
    public $Discounts;
    /**
     * Constructor method for CustomerPurchaseHistory
     * @uses CustomerPurchaseHistory::setTransactionTimestamp()
     * @uses CustomerPurchaseHistory::setPrice()
     * @uses CustomerPurchaseHistory::setQuantity()
     * @uses CustomerPurchaseHistory::setHistoryReceiptType()
     * @uses CustomerPurchaseHistory::setLineType()
     * @uses CustomerPurchaseHistory::setReceiptNo()
     * @uses CustomerPurchaseHistory::setPositionNo()
     * @uses CustomerPurchaseHistory::setZNumber()
     * @uses CustomerPurchaseHistory::setPriceAlteration()
     * @uses CustomerPurchaseHistory::setTotalDiscount()
     * @uses CustomerPurchaseHistory::setBonusDiscount()
     * @uses CustomerPurchaseHistory::setCustomerId()
     * @uses CustomerPurchaseHistory::setReceiptText()
     * @uses CustomerPurchaseHistory::setBranchId()
     * @uses CustomerPurchaseHistory::setProductGroupId()
     * @uses CustomerPurchaseHistory::setEAN()
     * @uses CustomerPurchaseHistory::setSerialNo()
     * @uses CustomerPurchaseHistory::setDocumentId()
     * @uses CustomerPurchaseHistory::setSalesPersonId()
     * @uses CustomerPurchaseHistory::setCashId()
     * @uses CustomerPurchaseHistory::setArticleId()
     * @uses CustomerPurchaseHistory::setDiscounts()
     * @param string $transactionTimestamp
     * @param float $price
     * @param float $quantity
     * @param string $historyReceiptType
     * @param string $lineType
     * @param int $receiptNo
     * @param int $positionNo
     * @param int $zNumber
     * @param float $priceAlteration
     * @param float $totalDiscount
     * @param float $bonusDiscount
     * @param string $customerId
     * @param string $receiptText
     * @param string $branchId
     * @param string $productGroupId
     * @param string $eAN
     * @param string $serialNo
     * @param string $documentId
     * @param string $salesPersonId
     * @param string $cashId
     * @param string $articleId
     * @param \ArrayType\ArrayOfDiscount $discounts
     */
    public function __construct($transactionTimestamp = null, $price = null, $quantity = null, $historyReceiptType = null, $lineType = null, $receiptNo = null, $positionNo = null, $zNumber = null, $priceAlteration = null, $totalDiscount = null, $bonusDiscount = null, $customerId = null, $receiptText = null, $branchId = null, $productGroupId = null, $eAN = null, $serialNo = null, $documentId = null, $salesPersonId = null, $cashId = null, $articleId = null, \ArrayType\ArrayOfDiscount $discounts = null)
    {
        $this
            ->setTransactionTimestamp($transactionTimestamp)
            ->setPrice($price)
            ->setQuantity($quantity)
            ->setHistoryReceiptType($historyReceiptType)
            ->setLineType($lineType)
            ->setReceiptNo($receiptNo)
            ->setPositionNo($positionNo)
            ->setZNumber($zNumber)
            ->setPriceAlteration($priceAlteration)
            ->setTotalDiscount($totalDiscount)
            ->setBonusDiscount($bonusDiscount)
            ->setCustomerId($customerId)
            ->setReceiptText($receiptText)
            ->setBranchId($branchId)
            ->setProductGroupId($productGroupId)
            ->setEAN($eAN)
            ->setSerialNo($serialNo)
            ->setDocumentId($documentId)
            ->setSalesPersonId($salesPersonId)
            ->setCashId($cashId)
            ->setArticleId($articleId)
            ->setDiscounts($discounts);
    }
    /**
     * Get TransactionTimestamp value
     * @return string
     */
    public function getTransactionTimestamp()
    {
        return $this->TransactionTimestamp;
    }
    /**
     * Set TransactionTimestamp value
     * @param string $transactionTimestamp
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setTransactionTimestamp($transactionTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTimestamp) && !is_string($transactionTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionTimestamp, true), gettype($transactionTimestamp)), __LINE__);
        }
        $this->TransactionTimestamp = $transactionTimestamp;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get HistoryReceiptType value
     * @return string
     */
    public function getHistoryReceiptType()
    {
        return $this->HistoryReceiptType;
    }
    /**
     * Set HistoryReceiptType value
     * @uses \EnumType\HistoryReceiptType::valueIsValid()
     * @uses \EnumType\HistoryReceiptType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $historyReceiptType
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setHistoryReceiptType($historyReceiptType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HistoryReceiptType::valueIsValid($historyReceiptType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HistoryReceiptType', is_array($historyReceiptType) ? implode(', ', $historyReceiptType) : var_export($historyReceiptType, true), implode(', ', \EnumType\HistoryReceiptType::getValidValues())), __LINE__);
        }
        $this->HistoryReceiptType = $historyReceiptType;
        return $this;
    }
    /**
     * Get LineType value
     * @return string
     */
    public function getLineType()
    {
        return $this->LineType;
    }
    /**
     * Set LineType value
     * @uses \EnumType\LineType::valueIsValid()
     * @uses \EnumType\LineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineType
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LineType::valueIsValid($lineType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LineType', is_array($lineType) ? implode(', ', $lineType) : var_export($lineType, true), implode(', ', \EnumType\LineType::getValidValues())), __LINE__);
        }
        $this->LineType = $lineType;
        return $this;
    }
    /**
     * Get ReceiptNo value
     * @return int
     */
    public function getReceiptNo()
    {
        return $this->ReceiptNo;
    }
    /**
     * Set ReceiptNo value
     * @param int $receiptNo
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setReceiptNo($receiptNo = null)
    {
        // validation for constraint: int
        if (!is_null($receiptNo) && !(is_int($receiptNo) || ctype_digit($receiptNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptNo, true), gettype($receiptNo)), __LINE__);
        }
        $this->ReceiptNo = $receiptNo;
        return $this;
    }
    /**
     * Get PositionNo value
     * @return int
     */
    public function getPositionNo()
    {
        return $this->PositionNo;
    }
    /**
     * Set PositionNo value
     * @param int $positionNo
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setPositionNo($positionNo = null)
    {
        // validation for constraint: int
        if (!is_null($positionNo) && !(is_int($positionNo) || ctype_digit($positionNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionNo, true), gettype($positionNo)), __LINE__);
        }
        $this->PositionNo = $positionNo;
        return $this;
    }
    /**
     * Get ZNumber value
     * @return int
     */
    public function getZNumber()
    {
        return $this->ZNumber;
    }
    /**
     * Set ZNumber value
     * @param int $zNumber
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setZNumber($zNumber = null)
    {
        // validation for constraint: int
        if (!is_null($zNumber) && !(is_int($zNumber) || ctype_digit($zNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zNumber, true), gettype($zNumber)), __LINE__);
        }
        $this->ZNumber = $zNumber;
        return $this;
    }
    /**
     * Get PriceAlteration value
     * @return float
     */
    public function getPriceAlteration()
    {
        return $this->PriceAlteration;
    }
    /**
     * Set PriceAlteration value
     * @param float $priceAlteration
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setPriceAlteration($priceAlteration = null)
    {
        // validation for constraint: float
        if (!is_null($priceAlteration) && !(is_float($priceAlteration) || is_numeric($priceAlteration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceAlteration, true), gettype($priceAlteration)), __LINE__);
        }
        $this->PriceAlteration = $priceAlteration;
        return $this;
    }
    /**
     * Get TotalDiscount value
     * @return float
     */
    public function getTotalDiscount()
    {
        return $this->TotalDiscount;
    }
    /**
     * Set TotalDiscount value
     * @param float $totalDiscount
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setTotalDiscount($totalDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($totalDiscount) && !(is_float($totalDiscount) || is_numeric($totalDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDiscount, true), gettype($totalDiscount)), __LINE__);
        }
        $this->TotalDiscount = $totalDiscount;
        return $this;
    }
    /**
     * Get BonusDiscount value
     * @return float
     */
    public function getBonusDiscount()
    {
        return $this->BonusDiscount;
    }
    /**
     * Set BonusDiscount value
     * @param float $bonusDiscount
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setBonusDiscount($bonusDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($bonusDiscount) && !(is_float($bonusDiscount) || is_numeric($bonusDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusDiscount, true), gettype($bonusDiscount)), __LINE__);
        }
        $this->BonusDiscount = $bonusDiscount;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ReceiptText value
     * @return string|null
     */
    public function getReceiptText()
    {
        return $this->ReceiptText;
    }
    /**
     * Set ReceiptText value
     * @param string $receiptText
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setReceiptText($receiptText = null)
    {
        // validation for constraint: string
        if (!is_null($receiptText) && !is_string($receiptText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptText, true), gettype($receiptText)), __LINE__);
        }
        $this->ReceiptText = $receiptText;
        return $this;
    }
    /**
     * Get BranchId value
     * @return string|null
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param string $branchId
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: string
        if (!is_null($branchId) && !is_string($branchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get ProductGroupId value
     * @return string|null
     */
    public function getProductGroupId()
    {
        return $this->ProductGroupId;
    }
    /**
     * Set ProductGroupId value
     * @param string $productGroupId
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setProductGroupId($productGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupId) && !is_string($productGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroupId, true), gettype($productGroupId)), __LINE__);
        }
        $this->ProductGroupId = $productGroupId;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get SerialNo value
     * @return string|null
     */
    public function getSerialNo()
    {
        return $this->SerialNo;
    }
    /**
     * Set SerialNo value
     * @param string $serialNo
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setSerialNo($serialNo = null)
    {
        // validation for constraint: string
        if (!is_null($serialNo) && !is_string($serialNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNo, true), gettype($serialNo)), __LINE__);
        }
        $this->SerialNo = $serialNo;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get SalesPersonId value
     * @return string|null
     */
    public function getSalesPersonId()
    {
        return $this->SalesPersonId;
    }
    /**
     * Set SalesPersonId value
     * @param string $salesPersonId
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setSalesPersonId($salesPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($salesPersonId) && !is_string($salesPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPersonId, true), gettype($salesPersonId)), __LINE__);
        }
        $this->SalesPersonId = $salesPersonId;
        return $this;
    }
    /**
     * Get CashId value
     * @return string|null
     */
    public function getCashId()
    {
        return $this->CashId;
    }
    /**
     * Set CashId value
     * @param string $cashId
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setCashId($cashId = null)
    {
        // validation for constraint: string
        if (!is_null($cashId) && !is_string($cashId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cashId, true), gettype($cashId)), __LINE__);
        }
        $this->CashId = $cashId;
        return $this;
    }
    /**
     * Get ArticleId value
     * @return string|null
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param string $articleId
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: string
        if (!is_null($articleId) && !is_string($articleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get Discounts value
     * @return \ArrayType\ArrayOfDiscount|null
     */
    public function getDiscounts()
    {
        return $this->Discounts;
    }
    /**
     * Set Discounts value
     * @param \ArrayType\ArrayOfDiscount $discounts
     * @return \StructType\CustomerPurchaseHistory
     */
    public function setDiscounts(\ArrayType\ArrayOfDiscount $discounts = null)
    {
        $this->Discounts = $discounts;
        return $this;
    }
}
