<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCard StructType
 * @subpackage Structs
 */
class CustomerCard extends BaseContract_FullIDSet
{
    /**
     * The Blocked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Blocked;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IssueDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpirationDate;
    /**
     * The CustomerCardType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerCardType;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * Constructor method for CustomerCard
     * @uses CustomerCard::setBlocked()
     * @uses CustomerCard::setIssueDate()
     * @uses CustomerCard::setExpirationDate()
     * @uses CustomerCard::setCustomerCardType()
     * @uses CustomerCard::setCustomerId()
     * @param bool $blocked
     * @param string $issueDate
     * @param string $expirationDate
     * @param string $customerCardType
     * @param string $customerId
     */
    public function __construct($blocked = null, $issueDate = null, $expirationDate = null, $customerCardType = null, $customerId = null)
    {
        $this
            ->setBlocked($blocked)
            ->setIssueDate($issueDate)
            ->setExpirationDate($expirationDate)
            ->setCustomerCardType($customerCardType)
            ->setCustomerId($customerId);
    }
    /**
     * Get Blocked value
     * @return bool
     */
    public function getBlocked()
    {
        return $this->Blocked;
    }
    /**
     * Set Blocked value
     * @param bool $blocked
     * @return \StructType\CustomerCard
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($blocked) && !is_bool($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blocked, true), gettype($blocked)), __LINE__);
        }
        $this->Blocked = $blocked;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\CustomerCard
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\CustomerCard
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get CustomerCardType value
     * @return string
     */
    public function getCustomerCardType()
    {
        return $this->CustomerCardType;
    }
    /**
     * Set CustomerCardType value
     * @uses \EnumType\CardType::valueIsValid()
     * @uses \EnumType\CardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerCardType
     * @return \StructType\CustomerCard
     */
    public function setCustomerCardType($customerCardType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CardType::valueIsValid($customerCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CardType', is_array($customerCardType) ? implode(', ', $customerCardType) : var_export($customerCardType, true), implode(', ', \EnumType\CardType::getValidValues())), __LINE__);
        }
        $this->CustomerCardType = $customerCardType;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\CustomerCard
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
}
