<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Currency StructType
 * @subpackage Structs
 */
class Currency extends BaseContract_Oid
{
    /**
     * The RoundingMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RoundingMode;
    /**
     * The RoundingValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RoundingValue;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PrintingSymbol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrintingSymbol;
    /**
     * Constructor method for Currency
     * @uses Currency::setRoundingMode()
     * @uses Currency::setRoundingValue()
     * @uses Currency::setCurrencyISO()
     * @uses Currency::setDescription()
     * @uses Currency::setPrintingSymbol()
     * @param string $roundingMode
     * @param float $roundingValue
     * @param string $currencyISO
     * @param string $description
     * @param string $printingSymbol
     */
    public function __construct($roundingMode = null, $roundingValue = null, $currencyISO = null, $description = null, $printingSymbol = null)
    {
        $this
            ->setRoundingMode($roundingMode)
            ->setRoundingValue($roundingValue)
            ->setCurrencyISO($currencyISO)
            ->setDescription($description)
            ->setPrintingSymbol($printingSymbol);
    }
    /**
     * Get RoundingMode value
     * @return string
     */
    public function getRoundingMode()
    {
        return $this->RoundingMode;
    }
    /**
     * Set RoundingMode value
     * @uses \EnumType\RoundingMode::valueIsValid()
     * @uses \EnumType\RoundingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roundingMode
     * @return \StructType\Currency
     */
    public function setRoundingMode($roundingMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoundingMode::valueIsValid($roundingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RoundingMode', is_array($roundingMode) ? implode(', ', $roundingMode) : var_export($roundingMode, true), implode(', ', \EnumType\RoundingMode::getValidValues())), __LINE__);
        }
        $this->RoundingMode = $roundingMode;
        return $this;
    }
    /**
     * Get RoundingValue value
     * @return float
     */
    public function getRoundingValue()
    {
        return $this->RoundingValue;
    }
    /**
     * Set RoundingValue value
     * @param float $roundingValue
     * @return \StructType\Currency
     */
    public function setRoundingValue($roundingValue = null)
    {
        // validation for constraint: float
        if (!is_null($roundingValue) && !(is_float($roundingValue) || is_numeric($roundingValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($roundingValue, true), gettype($roundingValue)), __LINE__);
        }
        $this->RoundingValue = $roundingValue;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\Currency
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Currency
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PrintingSymbol value
     * @return string|null
     */
    public function getPrintingSymbol()
    {
        return $this->PrintingSymbol;
    }
    /**
     * Set PrintingSymbol value
     * @param string $printingSymbol
     * @return \StructType\Currency
     */
    public function setPrintingSymbol($printingSymbol = null)
    {
        // validation for constraint: string
        if (!is_null($printingSymbol) && !is_string($printingSymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingSymbol, true), gettype($printingSymbol)), __LINE__);
        }
        $this->PrintingSymbol = $printingSymbol;
        return $this;
    }
}
