<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryRequest StructType
 * @subpackage Structs
 */
class CountryRequest extends AbstractStructBase
{
    /**
     * The CountryISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryISO;
    /**
     * Constructor method for CountryRequest
     * @uses CountryRequest::setCountryISO()
     * @param string $countryISO
     */
    public function __construct($countryISO = null)
    {
        $this
            ->setCountryISO($countryISO);
    }
    /**
     * Get CountryISO value
     * @return string|null
     */
    public function getCountryISO()
    {
        return $this->CountryISO;
    }
    /**
     * Set CountryISO value
     * @param string $countryISO
     * @return \StructType\CountryRequest
     */
    public function setCountryISO($countryISO = null)
    {
        // validation for constraint: string
        if (!is_null($countryISO) && !is_string($countryISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryISO, true), gettype($countryISO)), __LINE__);
        }
        $this->CountryISO = $countryISO;
        return $this;
    }
}
