<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommChannelType StructType
 * @subpackage Structs
 */
class CommChannelType extends EntityContractBase
{
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSystem;
    /**
     * The DoubleOptInRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DoubleOptInRequired;
    /**
     * The PosTypeNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PosTypeNo;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CommChannelType
     * @uses CommChannelType::setIsSystem()
     * @uses CommChannelType::setDoubleOptInRequired()
     * @uses CommChannelType::setPosTypeNo()
     * @uses CommChannelType::setName()
     * @param bool $isSystem
     * @param bool $doubleOptInRequired
     * @param int $posTypeNo
     * @param string $name
     */
    public function __construct($isSystem = null, $doubleOptInRequired = null, $posTypeNo = null, $name = null)
    {
        $this
            ->setIsSystem($isSystem)
            ->setDoubleOptInRequired($doubleOptInRequired)
            ->setPosTypeNo($posTypeNo)
            ->setName($name);
    }
    /**
     * Get IsSystem value
     * @return bool
     */
    public function getIsSystem()
    {
        return $this->IsSystem;
    }
    /**
     * Set IsSystem value
     * @param bool $isSystem
     * @return \StructType\CommChannelType
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        $this->IsSystem = $isSystem;
        return $this;
    }
    /**
     * Get DoubleOptInRequired value
     * @return bool
     */
    public function getDoubleOptInRequired()
    {
        return $this->DoubleOptInRequired;
    }
    /**
     * Set DoubleOptInRequired value
     * @param bool $doubleOptInRequired
     * @return \StructType\CommChannelType
     */
    public function setDoubleOptInRequired($doubleOptInRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($doubleOptInRequired) && !is_bool($doubleOptInRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doubleOptInRequired, true), gettype($doubleOptInRequired)), __LINE__);
        }
        $this->DoubleOptInRequired = $doubleOptInRequired;
        return $this;
    }
    /**
     * Get PosTypeNo value
     * @return int
     */
    public function getPosTypeNo()
    {
        return $this->PosTypeNo;
    }
    /**
     * Set PosTypeNo value
     * @param int $posTypeNo
     * @return \StructType\CommChannelType
     */
    public function setPosTypeNo($posTypeNo = null)
    {
        // validation for constraint: int
        if (!is_null($posTypeNo) && !(is_int($posTypeNo) || ctype_digit($posTypeNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($posTypeNo, true), gettype($posTypeNo)), __LINE__);
        }
        $this->PosTypeNo = $posTypeNo;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CommChannelType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
