<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommChannel StructType
 * @subpackage Structs
 */
class CommChannel extends VoidableEntityContractBase
{
    /**
     * The AdvertisingPermission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AdvertisingPermission;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactId;
    /**
     * The CommChannelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommChannelType
     */
    public $CommChannelType;
    /**
     * The TimeZoneId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeZoneId;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The SourceAddressOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceAddressOid;
    /**
     * Constructor method for CommChannel
     * @uses CommChannel::setAdvertisingPermission()
     * @uses CommChannel::setContactId()
     * @uses CommChannel::setCommChannelType()
     * @uses CommChannel::setTimeZoneId()
     * @uses CommChannel::setValue()
     * @uses CommChannel::setSourceAddressOid()
     * @param string $advertisingPermission
     * @param string $contactId
     * @param \StructType\CommChannelType $commChannelType
     * @param string $timeZoneId
     * @param string $value
     * @param string $sourceAddressOid
     */
    public function __construct($advertisingPermission = null, $contactId = null, \StructType\CommChannelType $commChannelType = null, $timeZoneId = null, $value = null, $sourceAddressOid = null)
    {
        $this
            ->setAdvertisingPermission($advertisingPermission)
            ->setContactId($contactId)
            ->setCommChannelType($commChannelType)
            ->setTimeZoneId($timeZoneId)
            ->setValue($value)
            ->setSourceAddressOid($sourceAddressOid);
    }
    /**
     * Get AdvertisingPermission value
     * @return string
     */
    public function getAdvertisingPermission()
    {
        return $this->AdvertisingPermission;
    }
    /**
     * Set AdvertisingPermission value
     * @uses \EnumType\AdvertisingPermission::valueIsValid()
     * @uses \EnumType\AdvertisingPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $advertisingPermission
     * @return \StructType\CommChannel
     */
    public function setAdvertisingPermission($advertisingPermission = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdvertisingPermission::valueIsValid($advertisingPermission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdvertisingPermission', is_array($advertisingPermission) ? implode(', ', $advertisingPermission) : var_export($advertisingPermission, true), implode(', ', \EnumType\AdvertisingPermission::getValidValues())), __LINE__);
        }
        $this->AdvertisingPermission = $advertisingPermission;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\CommChannel
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get CommChannelType value
     * @return \StructType\CommChannelType|null
     */
    public function getCommChannelType()
    {
        return $this->CommChannelType;
    }
    /**
     * Set CommChannelType value
     * @param \StructType\CommChannelType $commChannelType
     * @return \StructType\CommChannel
     */
    public function setCommChannelType(\StructType\CommChannelType $commChannelType = null)
    {
        $this->CommChannelType = $commChannelType;
        return $this;
    }
    /**
     * Get TimeZoneId value
     * @return string|null
     */
    public function getTimeZoneId()
    {
        return $this->TimeZoneId;
    }
    /**
     * Set TimeZoneId value
     * @param string $timeZoneId
     * @return \StructType\CommChannel
     */
    public function setTimeZoneId($timeZoneId = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneId) && !is_string($timeZoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneId, true), gettype($timeZoneId)), __LINE__);
        }
        $this->TimeZoneId = $timeZoneId;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\CommChannel
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get SourceAddressOid value
     * @return string|null
     */
    public function getSourceAddressOid()
    {
        return $this->SourceAddressOid;
    }
    /**
     * Set SourceAddressOid value
     * @param string $sourceAddressOid
     * @return \StructType\CommChannel
     */
    public function setSourceAddressOid($sourceAddressOid = null)
    {
        // validation for constraint: string
        if (!is_null($sourceAddressOid) && !is_string($sourceAddressOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceAddressOid, true), gettype($sourceAddressOid)), __LINE__);
        }
        $this->SourceAddressOid = $sourceAddressOid;
        return $this;
    }
}
