<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckDeletedObjectRequest StructType
 * @subpackage Structs
 */
class CheckDeletedObjectRequest extends BaseRequest
{
    /**
     * The ExternalRecordId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalRecordId;
    /**
     * The RecordId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecordId;
    /**
     * Constructor method for CheckDeletedObjectRequest
     * @uses CheckDeletedObjectRequest::setExternalRecordId()
     * @uses CheckDeletedObjectRequest::setRecordId()
     * @param string $externalRecordId
     * @param string $recordId
     */
    public function __construct($externalRecordId = null, $recordId = null)
    {
        $this
            ->setExternalRecordId($externalRecordId)
            ->setRecordId($recordId);
    }
    /**
     * Get ExternalRecordId value
     * @return string|null
     */
    public function getExternalRecordId()
    {
        return $this->ExternalRecordId;
    }
    /**
     * Set ExternalRecordId value
     * @param string $externalRecordId
     * @return \StructType\CheckDeletedObjectRequest
     */
    public function setExternalRecordId($externalRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($externalRecordId) && !is_string($externalRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalRecordId, true), gettype($externalRecordId)), __LINE__);
        }
        $this->ExternalRecordId = $externalRecordId;
        return $this;
    }
    /**
     * Get RecordId value
     * @return string|null
     */
    public function getRecordId()
    {
        return $this->RecordId;
    }
    /**
     * Set RecordId value
     * @param string $recordId
     * @return \StructType\CheckDeletedObjectRequest
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: string
        if (!is_null($recordId) && !is_string($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordId, true), gettype($recordId)), __LINE__);
        }
        $this->RecordId = $recordId;
        return $this;
    }
}
