<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CharacteristicTypeRequest StructType
 * @subpackage Structs
 */
class CharacteristicTypeRequest extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The Kind
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Kind;
    /**
     * Constructor method for CharacteristicTypeRequest
     * @uses CharacteristicTypeRequest::setID()
     * @uses CharacteristicTypeRequest::setKind()
     * @param int $iD
     * @param string $kind
     */
    public function __construct($iD = null, $kind = null)
    {
        $this
            ->setID($iD)
            ->setKind($kind);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\CharacteristicTypeRequest
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Kind value
     * @return string
     */
    public function getKind()
    {
        return $this->Kind;
    }
    /**
     * Set Kind value
     * @uses \EnumType\CharacteristicKind::valueIsValid()
     * @uses \EnumType\CharacteristicKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return \StructType\CharacteristicTypeRequest
     */
    public function setKind($kind = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CharacteristicKind::valueIsValid($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CharacteristicKind', is_array($kind) ? implode(', ', $kind) : var_export($kind, true), implode(', ', \EnumType\CharacteristicKind::getValidValues())), __LINE__);
        }
        $this->Kind = $kind;
        return $this;
    }
}
