<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Branch StructType
 * @subpackage Structs
 */
class Branch extends BaseContract_FullIDSet
{
    /**
     * The VatConfigurationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VatConfigurationId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $Contact;
    /**
     * Constructor method for Branch
     * @uses Branch::setVatConfigurationId()
     * @uses Branch::setDescription()
     * @uses Branch::setContact()
     * @param int $vatConfigurationId
     * @param string $description
     * @param \StructType\Person $contact
     */
    public function __construct($vatConfigurationId = null, $description = null, \StructType\Person $contact = null)
    {
        $this
            ->setVatConfigurationId($vatConfigurationId)
            ->setDescription($description)
            ->setContact($contact);
    }
    /**
     * Get VatConfigurationId value
     * @return int
     */
    public function getVatConfigurationId()
    {
        return $this->VatConfigurationId;
    }
    /**
     * Set VatConfigurationId value
     * @param int $vatConfigurationId
     * @return \StructType\Branch
     */
    public function setVatConfigurationId($vatConfigurationId = null)
    {
        // validation for constraint: int
        if (!is_null($vatConfigurationId) && !(is_int($vatConfigurationId) || ctype_digit($vatConfigurationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatConfigurationId, true), gettype($vatConfigurationId)), __LINE__);
        }
        $this->VatConfigurationId = $vatConfigurationId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Branch
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\Person|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\Person $contact
     * @return \StructType\Branch
     */
    public function setContact(\StructType\Person $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
}
