<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseCreatorResponse StructType
 * @subpackage Structs
 */
class BaseCreatorResponse extends BaseResponse
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StatusMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * Constructor method for BaseCreatorResponse
     * @uses BaseCreatorResponse::setStatus()
     * @uses BaseCreatorResponse::setStatusMessage()
     * @param string $status
     * @param string $statusMessage
     */
    public function __construct($status = null, $statusMessage = null)
    {
        $this
            ->setStatus($status)
            ->setStatusMessage($statusMessage);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\CreationStatus::valueIsValid()
     * @uses \EnumType\CreationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BaseCreatorResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreationStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\CreationStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \StructType\BaseCreatorResponse
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusMessage, true), gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
}
