<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends VoidableEntityContractBase
{
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EntityType;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Gender;
    /**
     * The AddressCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AddressCategory;
    /**
     * The RetailAddressType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RetailAddressType;
    /**
     * The AdvertisingPermission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AdvertisingPermission;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The AddressType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AddressText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressText;
    /**
     * The SalutationKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalutationKey;
    /**
     * The FirstnameOrOrgname1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstnameOrOrgname1;
    /**
     * The MiddlenameOrOrgname2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddlenameOrOrgname2;
    /**
     * The LastnameOrOrgname3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastnameOrOrgname3;
    /**
     * The NamesuffixOrOrgname4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamesuffixOrOrgname4;
    /**
     * The TitleOrOrgname5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TitleOrOrgname5;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The StreetNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetNo;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The EMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMail;
    /**
     * The HomePage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomePage;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Position;
    /**
     * The LanguageISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageISO;
    /**
     * The AdditionalRow1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalRow1;
    /**
     * The AdditionalRow2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalRow2;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactId;
    /**
     * The TimeZoneId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeZoneId;
    /**
     * The CountryIdIso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryIdIso;
    /**
     * The RegionIdIso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegionIdIso;
    /**
     * The PostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostCode;
    /**
     * The PostOfficeBox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostOfficeBox;
    /**
     * The County
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The Quarter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Quarter;
    /**
     * The PostalDistrict
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalDistrict;
    /**
     * The Block
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Block;
    /**
     * The BuildingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingNumber;
    /**
     * The BuildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingName;
    /**
     * The Department
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Department;
    /**
     * The Floor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Floor;
    /**
     * The FlatNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlatNumber;
    /**
     * Constructor method for Address
     * @uses Address::setEntityType()
     * @uses Address::setGender()
     * @uses Address::setAddressCategory()
     * @uses Address::setRetailAddressType()
     * @uses Address::setAdvertisingPermission()
     * @uses Address::setLongitude()
     * @uses Address::setLatitude()
     * @uses Address::setAddressType()
     * @uses Address::setDescription()
     * @uses Address::setAddressText()
     * @uses Address::setSalutationKey()
     * @uses Address::setFirstnameOrOrgname1()
     * @uses Address::setMiddlenameOrOrgname2()
     * @uses Address::setLastnameOrOrgname3()
     * @uses Address::setNamesuffixOrOrgname4()
     * @uses Address::setTitleOrOrgname5()
     * @uses Address::setStreet()
     * @uses Address::setStreetNo()
     * @uses Address::setZipCode()
     * @uses Address::setCity()
     * @uses Address::setRegion()
     * @uses Address::setCountry()
     * @uses Address::setFax()
     * @uses Address::setPhone()
     * @uses Address::setMobile()
     * @uses Address::setEMail()
     * @uses Address::setHomePage()
     * @uses Address::setPosition()
     * @uses Address::setLanguageISO()
     * @uses Address::setAdditionalRow1()
     * @uses Address::setAdditionalRow2()
     * @uses Address::setContactId()
     * @uses Address::setTimeZoneId()
     * @uses Address::setCountryIdIso()
     * @uses Address::setRegionIdIso()
     * @uses Address::setPostCode()
     * @uses Address::setPostOfficeBox()
     * @uses Address::setCounty()
     * @uses Address::setQuarter()
     * @uses Address::setPostalDistrict()
     * @uses Address::setBlock()
     * @uses Address::setBuildingNumber()
     * @uses Address::setBuildingName()
     * @uses Address::setDepartment()
     * @uses Address::setFloor()
     * @uses Address::setFlatNumber()
     * @param string $entityType
     * @param string $gender
     * @param string $addressCategory
     * @param string $retailAddressType
     * @param string $advertisingPermission
     * @param float $longitude
     * @param float $latitude
     * @param string $addressType
     * @param string $description
     * @param string $addressText
     * @param string $salutationKey
     * @param string $firstnameOrOrgname1
     * @param string $middlenameOrOrgname2
     * @param string $lastnameOrOrgname3
     * @param string $namesuffixOrOrgname4
     * @param string $titleOrOrgname5
     * @param string $street
     * @param string $streetNo
     * @param string $zipCode
     * @param string $city
     * @param string $region
     * @param string $country
     * @param string $fax
     * @param string $phone
     * @param string $mobile
     * @param string $eMail
     * @param string $homePage
     * @param string $position
     * @param string $languageISO
     * @param string $additionalRow1
     * @param string $additionalRow2
     * @param string $contactId
     * @param string $timeZoneId
     * @param string $countryIdIso
     * @param string $regionIdIso
     * @param string $postCode
     * @param string $postOfficeBox
     * @param string $county
     * @param string $quarter
     * @param string $postalDistrict
     * @param string $block
     * @param string $buildingNumber
     * @param string $buildingName
     * @param string $department
     * @param string $floor
     * @param string $flatNumber
     */
    public function __construct($entityType = null, $gender = null, $addressCategory = null, $retailAddressType = null, $advertisingPermission = null, $longitude = null, $latitude = null, $addressType = null, $description = null, $addressText = null, $salutationKey = null, $firstnameOrOrgname1 = null, $middlenameOrOrgname2 = null, $lastnameOrOrgname3 = null, $namesuffixOrOrgname4 = null, $titleOrOrgname5 = null, $street = null, $streetNo = null, $zipCode = null, $city = null, $region = null, $country = null, $fax = null, $phone = null, $mobile = null, $eMail = null, $homePage = null, $position = null, $languageISO = null, $additionalRow1 = null, $additionalRow2 = null, $contactId = null, $timeZoneId = null, $countryIdIso = null, $regionIdIso = null, $postCode = null, $postOfficeBox = null, $county = null, $quarter = null, $postalDistrict = null, $block = null, $buildingNumber = null, $buildingName = null, $department = null, $floor = null, $flatNumber = null)
    {
        $this
            ->setEntityType($entityType)
            ->setGender($gender)
            ->setAddressCategory($addressCategory)
            ->setRetailAddressType($retailAddressType)
            ->setAdvertisingPermission($advertisingPermission)
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setAddressType($addressType)
            ->setDescription($description)
            ->setAddressText($addressText)
            ->setSalutationKey($salutationKey)
            ->setFirstnameOrOrgname1($firstnameOrOrgname1)
            ->setMiddlenameOrOrgname2($middlenameOrOrgname2)
            ->setLastnameOrOrgname3($lastnameOrOrgname3)
            ->setNamesuffixOrOrgname4($namesuffixOrOrgname4)
            ->setTitleOrOrgname5($titleOrOrgname5)
            ->setStreet($street)
            ->setStreetNo($streetNo)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setRegion($region)
            ->setCountry($country)
            ->setFax($fax)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setEMail($eMail)
            ->setHomePage($homePage)
            ->setPosition($position)
            ->setLanguageISO($languageISO)
            ->setAdditionalRow1($additionalRow1)
            ->setAdditionalRow2($additionalRow2)
            ->setContactId($contactId)
            ->setTimeZoneId($timeZoneId)
            ->setCountryIdIso($countryIdIso)
            ->setRegionIdIso($regionIdIso)
            ->setPostCode($postCode)
            ->setPostOfficeBox($postOfficeBox)
            ->setCounty($county)
            ->setQuarter($quarter)
            ->setPostalDistrict($postalDistrict)
            ->setBlock($block)
            ->setBuildingNumber($buildingNumber)
            ->setBuildingName($buildingName)
            ->setDepartment($department)
            ->setFloor($floor)
            ->setFlatNumber($flatNumber);
    }
    /**
     * Get EntityType value
     * @return string
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\Address
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\ContactGender::valueIsValid()
     * @uses \EnumType\ContactGender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\Address
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactGender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContactGender', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\ContactGender::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get AddressCategory value
     * @return string
     */
    public function getAddressCategory()
    {
        return $this->AddressCategory;
    }
    /**
     * Set AddressCategory value
     * @uses \EnumType\AddressCategory::valueIsValid()
     * @uses \EnumType\AddressCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressCategory
     * @return \StructType\Address
     */
    public function setAddressCategory($addressCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressCategory::valueIsValid($addressCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AddressCategory', is_array($addressCategory) ? implode(', ', $addressCategory) : var_export($addressCategory, true), implode(', ', \EnumType\AddressCategory::getValidValues())), __LINE__);
        }
        $this->AddressCategory = $addressCategory;
        return $this;
    }
    /**
     * Get RetailAddressType value
     * @return string
     */
    public function getRetailAddressType()
    {
        return $this->RetailAddressType;
    }
    /**
     * Set RetailAddressType value
     * @uses \EnumType\RetailAddressType::valueIsValid()
     * @uses \EnumType\RetailAddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retailAddressType
     * @return \StructType\Address
     */
    public function setRetailAddressType($retailAddressType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetailAddressType::valueIsValid($retailAddressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetailAddressType', is_array($retailAddressType) ? implode(', ', $retailAddressType) : var_export($retailAddressType, true), implode(', ', \EnumType\RetailAddressType::getValidValues())), __LINE__);
        }
        $this->RetailAddressType = $retailAddressType;
        return $this;
    }
    /**
     * Get AdvertisingPermission value
     * @return string
     */
    public function getAdvertisingPermission()
    {
        return $this->AdvertisingPermission;
    }
    /**
     * Set AdvertisingPermission value
     * @uses \EnumType\AdvertisingPermission::valueIsValid()
     * @uses \EnumType\AdvertisingPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $advertisingPermission
     * @return \StructType\Address
     */
    public function setAdvertisingPermission($advertisingPermission = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdvertisingPermission::valueIsValid($advertisingPermission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdvertisingPermission', is_array($advertisingPermission) ? implode(', ', $advertisingPermission) : var_export($advertisingPermission, true), implode(', ', \EnumType\AdvertisingPermission::getValidValues())), __LINE__);
        }
        $this->AdvertisingPermission = $advertisingPermission;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\Address
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\Address
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @param string $addressType
     * @return \StructType\Address
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressType, true), gettype($addressType)), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Address
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AddressText value
     * @return string|null
     */
    public function getAddressText()
    {
        return $this->AddressText;
    }
    /**
     * Set AddressText value
     * @param string $addressText
     * @return \StructType\Address
     */
    public function setAddressText($addressText = null)
    {
        // validation for constraint: string
        if (!is_null($addressText) && !is_string($addressText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressText, true), gettype($addressText)), __LINE__);
        }
        $this->AddressText = $addressText;
        return $this;
    }
    /**
     * Get SalutationKey value
     * @return string|null
     */
    public function getSalutationKey()
    {
        return $this->SalutationKey;
    }
    /**
     * Set SalutationKey value
     * @param string $salutationKey
     * @return \StructType\Address
     */
    public function setSalutationKey($salutationKey = null)
    {
        // validation for constraint: string
        if (!is_null($salutationKey) && !is_string($salutationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutationKey, true), gettype($salutationKey)), __LINE__);
        }
        $this->SalutationKey = $salutationKey;
        return $this;
    }
    /**
     * Get FirstnameOrOrgname1 value
     * @return string|null
     */
    public function getFirstnameOrOrgname1()
    {
        return $this->FirstnameOrOrgname1;
    }
    /**
     * Set FirstnameOrOrgname1 value
     * @param string $firstnameOrOrgname1
     * @return \StructType\Address
     */
    public function setFirstnameOrOrgname1($firstnameOrOrgname1 = null)
    {
        // validation for constraint: string
        if (!is_null($firstnameOrOrgname1) && !is_string($firstnameOrOrgname1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstnameOrOrgname1, true), gettype($firstnameOrOrgname1)), __LINE__);
        }
        $this->FirstnameOrOrgname1 = $firstnameOrOrgname1;
        return $this;
    }
    /**
     * Get MiddlenameOrOrgname2 value
     * @return string|null
     */
    public function getMiddlenameOrOrgname2()
    {
        return $this->MiddlenameOrOrgname2;
    }
    /**
     * Set MiddlenameOrOrgname2 value
     * @param string $middlenameOrOrgname2
     * @return \StructType\Address
     */
    public function setMiddlenameOrOrgname2($middlenameOrOrgname2 = null)
    {
        // validation for constraint: string
        if (!is_null($middlenameOrOrgname2) && !is_string($middlenameOrOrgname2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middlenameOrOrgname2, true), gettype($middlenameOrOrgname2)), __LINE__);
        }
        $this->MiddlenameOrOrgname2 = $middlenameOrOrgname2;
        return $this;
    }
    /**
     * Get LastnameOrOrgname3 value
     * @return string|null
     */
    public function getLastnameOrOrgname3()
    {
        return $this->LastnameOrOrgname3;
    }
    /**
     * Set LastnameOrOrgname3 value
     * @param string $lastnameOrOrgname3
     * @return \StructType\Address
     */
    public function setLastnameOrOrgname3($lastnameOrOrgname3 = null)
    {
        // validation for constraint: string
        if (!is_null($lastnameOrOrgname3) && !is_string($lastnameOrOrgname3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnameOrOrgname3, true), gettype($lastnameOrOrgname3)), __LINE__);
        }
        $this->LastnameOrOrgname3 = $lastnameOrOrgname3;
        return $this;
    }
    /**
     * Get NamesuffixOrOrgname4 value
     * @return string|null
     */
    public function getNamesuffixOrOrgname4()
    {
        return $this->NamesuffixOrOrgname4;
    }
    /**
     * Set NamesuffixOrOrgname4 value
     * @param string $namesuffixOrOrgname4
     * @return \StructType\Address
     */
    public function setNamesuffixOrOrgname4($namesuffixOrOrgname4 = null)
    {
        // validation for constraint: string
        if (!is_null($namesuffixOrOrgname4) && !is_string($namesuffixOrOrgname4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namesuffixOrOrgname4, true), gettype($namesuffixOrOrgname4)), __LINE__);
        }
        $this->NamesuffixOrOrgname4 = $namesuffixOrOrgname4;
        return $this;
    }
    /**
     * Get TitleOrOrgname5 value
     * @return string|null
     */
    public function getTitleOrOrgname5()
    {
        return $this->TitleOrOrgname5;
    }
    /**
     * Set TitleOrOrgname5 value
     * @param string $titleOrOrgname5
     * @return \StructType\Address
     */
    public function setTitleOrOrgname5($titleOrOrgname5 = null)
    {
        // validation for constraint: string
        if (!is_null($titleOrOrgname5) && !is_string($titleOrOrgname5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleOrOrgname5, true), gettype($titleOrOrgname5)), __LINE__);
        }
        $this->TitleOrOrgname5 = $titleOrOrgname5;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\Address
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get StreetNo value
     * @return string|null
     */
    public function getStreetNo()
    {
        return $this->StreetNo;
    }
    /**
     * Set StreetNo value
     * @param string $streetNo
     * @return \StructType\Address
     */
    public function setStreetNo($streetNo = null)
    {
        // validation for constraint: string
        if (!is_null($streetNo) && !is_string($streetNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNo, true), gettype($streetNo)), __LINE__);
        }
        $this->StreetNo = $streetNo;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\Address
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \StructType\Address
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\Address
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\Address
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\Address
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get EMail value
     * @return string|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param string $eMail
     * @return \StructType\Address
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get HomePage value
     * @return string|null
     */
    public function getHomePage()
    {
        return $this->HomePage;
    }
    /**
     * Set HomePage value
     * @param string $homePage
     * @return \StructType\Address
     */
    public function setHomePage($homePage = null)
    {
        // validation for constraint: string
        if (!is_null($homePage) && !is_string($homePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePage, true), gettype($homePage)), __LINE__);
        }
        $this->HomePage = $homePage;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param string $position
     * @return \StructType\Address
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get LanguageISO value
     * @return string|null
     */
    public function getLanguageISO()
    {
        return $this->LanguageISO;
    }
    /**
     * Set LanguageISO value
     * @param string $languageISO
     * @return \StructType\Address
     */
    public function setLanguageISO($languageISO = null)
    {
        // validation for constraint: string
        if (!is_null($languageISO) && !is_string($languageISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageISO, true), gettype($languageISO)), __LINE__);
        }
        $this->LanguageISO = $languageISO;
        return $this;
    }
    /**
     * Get AdditionalRow1 value
     * @return string|null
     */
    public function getAdditionalRow1()
    {
        return $this->AdditionalRow1;
    }
    /**
     * Set AdditionalRow1 value
     * @param string $additionalRow1
     * @return \StructType\Address
     */
    public function setAdditionalRow1($additionalRow1 = null)
    {
        // validation for constraint: string
        if (!is_null($additionalRow1) && !is_string($additionalRow1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalRow1, true), gettype($additionalRow1)), __LINE__);
        }
        $this->AdditionalRow1 = $additionalRow1;
        return $this;
    }
    /**
     * Get AdditionalRow2 value
     * @return string|null
     */
    public function getAdditionalRow2()
    {
        return $this->AdditionalRow2;
    }
    /**
     * Set AdditionalRow2 value
     * @param string $additionalRow2
     * @return \StructType\Address
     */
    public function setAdditionalRow2($additionalRow2 = null)
    {
        // validation for constraint: string
        if (!is_null($additionalRow2) && !is_string($additionalRow2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalRow2, true), gettype($additionalRow2)), __LINE__);
        }
        $this->AdditionalRow2 = $additionalRow2;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Address
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get TimeZoneId value
     * @return string|null
     */
    public function getTimeZoneId()
    {
        return $this->TimeZoneId;
    }
    /**
     * Set TimeZoneId value
     * @param string $timeZoneId
     * @return \StructType\Address
     */
    public function setTimeZoneId($timeZoneId = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneId) && !is_string($timeZoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneId, true), gettype($timeZoneId)), __LINE__);
        }
        $this->TimeZoneId = $timeZoneId;
        return $this;
    }
    /**
     * Get CountryIdIso value
     * @return string|null
     */
    public function getCountryIdIso()
    {
        return $this->CountryIdIso;
    }
    /**
     * Set CountryIdIso value
     * @param string $countryIdIso
     * @return \StructType\Address
     */
    public function setCountryIdIso($countryIdIso = null)
    {
        // validation for constraint: string
        if (!is_null($countryIdIso) && !is_string($countryIdIso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryIdIso, true), gettype($countryIdIso)), __LINE__);
        }
        $this->CountryIdIso = $countryIdIso;
        return $this;
    }
    /**
     * Get RegionIdIso value
     * @return string|null
     */
    public function getRegionIdIso()
    {
        return $this->RegionIdIso;
    }
    /**
     * Set RegionIdIso value
     * @param string $regionIdIso
     * @return \StructType\Address
     */
    public function setRegionIdIso($regionIdIso = null)
    {
        // validation for constraint: string
        if (!is_null($regionIdIso) && !is_string($regionIdIso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionIdIso, true), gettype($regionIdIso)), __LINE__);
        }
        $this->RegionIdIso = $regionIdIso;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \StructType\Address
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get PostOfficeBox value
     * @return string|null
     */
    public function getPostOfficeBox()
    {
        return $this->PostOfficeBox;
    }
    /**
     * Set PostOfficeBox value
     * @param string $postOfficeBox
     * @return \StructType\Address
     */
    public function setPostOfficeBox($postOfficeBox = null)
    {
        // validation for constraint: string
        if (!is_null($postOfficeBox) && !is_string($postOfficeBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postOfficeBox, true), gettype($postOfficeBox)), __LINE__);
        }
        $this->PostOfficeBox = $postOfficeBox;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \StructType\Address
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get Quarter value
     * @return string|null
     */
    public function getQuarter()
    {
        return $this->Quarter;
    }
    /**
     * Set Quarter value
     * @param string $quarter
     * @return \StructType\Address
     */
    public function setQuarter($quarter = null)
    {
        // validation for constraint: string
        if (!is_null($quarter) && !is_string($quarter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quarter, true), gettype($quarter)), __LINE__);
        }
        $this->Quarter = $quarter;
        return $this;
    }
    /**
     * Get PostalDistrict value
     * @return string|null
     */
    public function getPostalDistrict()
    {
        return $this->PostalDistrict;
    }
    /**
     * Set PostalDistrict value
     * @param string $postalDistrict
     * @return \StructType\Address
     */
    public function setPostalDistrict($postalDistrict = null)
    {
        // validation for constraint: string
        if (!is_null($postalDistrict) && !is_string($postalDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalDistrict, true), gettype($postalDistrict)), __LINE__);
        }
        $this->PostalDistrict = $postalDistrict;
        return $this;
    }
    /**
     * Get Block value
     * @return string|null
     */
    public function getBlock()
    {
        return $this->Block;
    }
    /**
     * Set Block value
     * @param string $block
     * @return \StructType\Address
     */
    public function setBlock($block = null)
    {
        // validation for constraint: string
        if (!is_null($block) && !is_string($block)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($block, true), gettype($block)), __LINE__);
        }
        $this->Block = $block;
        return $this;
    }
    /**
     * Get BuildingNumber value
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return $this->BuildingNumber;
    }
    /**
     * Set BuildingNumber value
     * @param string $buildingNumber
     * @return \StructType\Address
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNumber, true), gettype($buildingNumber)), __LINE__);
        }
        $this->BuildingNumber = $buildingNumber;
        return $this;
    }
    /**
     * Get BuildingName value
     * @return string|null
     */
    public function getBuildingName()
    {
        return $this->BuildingName;
    }
    /**
     * Set BuildingName value
     * @param string $buildingName
     * @return \StructType\Address
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        $this->BuildingName = $buildingName;
        return $this;
    }
    /**
     * Get Department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param string $department
     * @return \StructType\Address
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Get Floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param string $floor
     * @return \StructType\Address
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get FlatNumber value
     * @return string|null
     */
    public function getFlatNumber()
    {
        return $this->FlatNumber;
    }
    /**
     * Set FlatNumber value
     * @param string $flatNumber
     * @return \StructType\Address
     */
    public function setFlatNumber($flatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flatNumber) && !is_string($flatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flatNumber, true), gettype($flatNumber)), __LINE__);
        }
        $this->FlatNumber = $flatNumber;
        return $this;
    }
}
