<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCost StructType
 * @subpackage Structs
 */
class AdditionalCost extends BaseContract_FullIDSet
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Value;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CurrencyISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyISO;
    /**
     * The AdditionalCostDefinitionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalCostDefinitionId;
    /**
     * Constructor method for AdditionalCost
     * @uses AdditionalCost::setValue()
     * @uses AdditionalCost::setDescription()
     * @uses AdditionalCost::setCurrencyISO()
     * @uses AdditionalCost::setAdditionalCostDefinitionId()
     * @param float $value
     * @param string $description
     * @param string $currencyISO
     * @param string $additionalCostDefinitionId
     */
    public function __construct($value = null, $description = null, $currencyISO = null, $additionalCostDefinitionId = null)
    {
        $this
            ->setValue($value)
            ->setDescription($description)
            ->setCurrencyISO($currencyISO)
            ->setAdditionalCostDefinitionId($additionalCostDefinitionId);
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\AdditionalCost
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\AdditionalCost
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CurrencyISO value
     * @return string|null
     */
    public function getCurrencyISO()
    {
        return $this->CurrencyISO;
    }
    /**
     * Set CurrencyISO value
     * @param string $currencyISO
     * @return \StructType\AdditionalCost
     */
    public function setCurrencyISO($currencyISO = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISO) && !is_string($currencyISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISO, true), gettype($currencyISO)), __LINE__);
        }
        $this->CurrencyISO = $currencyISO;
        return $this;
    }
    /**
     * Get AdditionalCostDefinitionId value
     * @return string|null
     */
    public function getAdditionalCostDefinitionId()
    {
        return $this->AdditionalCostDefinitionId;
    }
    /**
     * Set AdditionalCostDefinitionId value
     * @param string $additionalCostDefinitionId
     * @return \StructType\AdditionalCost
     */
    public function setAdditionalCostDefinitionId($additionalCostDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($additionalCostDefinitionId) && !is_string($additionalCostDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalCostDefinitionId, true), gettype($additionalCostDefinitionId)), __LINE__);
        }
        $this->AdditionalCostDefinitionId = $additionalCostDefinitionId;
        return $this;
    }
}
