<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendGoodsInAdviceConfirmation
     * Meta information extracted from the WSDL
     * - documentation: Creates supplier delivery-notes for a specific supplier and multiple branches/scancodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendGoodsInAdviceConfirmation $parameters
     * @return \StructType\SendGoodsInAdviceConfirmationResponse|bool
     */
    public function SendGoodsInAdviceConfirmation(\StructType\SendGoodsInAdviceConfirmation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendGoodsInAdviceConfirmation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendStockCorrection
     * Meta information extracted from the WSDL
     * - documentation: Creates stock-corrections for a specific branch and multiple scancodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendStockCorrection $parameters
     * @return \StructType\SendStockCorrectionResponse|bool
     */
    public function SendStockCorrection(\StructType\SendStockCorrection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendStockCorrection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCustomer
     * Meta information extracted from the WSDL
     * - documentation: Sends a Customer object to create, update resp. assign a 4Retail (Shop)Customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCustomer $parameters
     * @return \StructType\SendCustomerResponse|bool
     */
    public function SendCustomer(\StructType\SendCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendDeliveryNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendDeliveryNotes $parameters
     * @return \StructType\SendDeliveryNotesResponse|bool
     */
    public function SendDeliveryNotes(\StructType\SendDeliveryNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDeliveryNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoices $parameters
     * @return \StructType\SendInvoicesResponse|bool
     */
    public function SendInvoices(\StructType\SendInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendOrders
     * Meta information extracted from the WSDL
     * - documentation: Sends an Order object to create resp. update a specific 4Retail order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendOrders $parameters
     * @return \StructType\SendOrdersResponse|bool
     */
    public function SendOrders(\StructType\SendOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendVouchers
     * Meta information extracted from the WSDL
     * - documentation: Sends a Voucher object to sale, assign, redeem and (re)charge a specific 4Retail gift voucher.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendVouchers $parameters
     * @return \StructType\SendVouchersResponse|bool
     */
    public function SendVouchers(\StructType\SendVouchers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendVouchers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSalesReceipt
     * Meta information extracted from the WSDL
     * - documentation: Sends a SalesReceipt object as a specified amount of sales/returns including disounts for Articles, Productgroups a/o Vouchers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSalesReceipt $parameters
     * @return \StructType\SendSalesReceiptResponse|bool
     */
    public function SendSalesReceipt(\StructType\SendSalesReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSalesReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendCustomerResponse|\StructType\SendDeliveryNotesResponse|\StructType\SendGoodsInAdviceConfirmationResponse|\StructType\SendInvoicesResponse|\StructType\SendOrdersResponse|\StructType\SendSalesReceiptResponse|\StructType\SendStockCorrectionResponse|\StructType\SendVouchersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
