<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckDeletedObject
     * Meta information extracted from the WSDL
     * - documentation: Checks the deleted object.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckDeletedObject $parameters
     * @return \StructType\CheckDeletedObjectResponse|bool
     */
    public function CheckDeletedObject(\StructType\CheckDeletedObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckDeletedObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckDeletedObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
